/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.lightapp.message.WFLinkNoticeAdapter;
import com.kingdee.lightapp.message.WFMessagePusherFactory;
import com.kingdee.lightapp.message.WFNoticeAdapter;
import com.kingdee.lightapp.message.WFPassAdapter;
import com.kingdee.lightapp.message.WFProcessinstAdapter;
import com.kingdee.lightapp.message.WFUrgentAdapter;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WFNoticeHandler {
    private static Logger logger = Logger.getLogger(WFNoticeHandler.class);

    public static int onMessage(Message message) {
        try {
            Context ctx = WFNoticeHandler.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
            logger.error((Object)("XT notice :: receive notice....." + message.getStringHeader("receiver")));
            String isSendCommon = message.getStringHeader("isSendCommon");
            String isSendEmail = message.getStringHeader("isSendEmail");
            String isSendMobile = message.getStringHeader("isSendMobile");
            String isParamSuspend = message.getStringHeader("isParamSuspend");
            boolean shouldHandle = WFNoticeHandler.checkShouldHandle(ctx);
            if (!shouldHandle) {
                return 1;
            }
            if (!"true".equals(isParamSuspend) && ("true".equals(isSendMobile) || "true".equals(isSendEmail))) {
                return 1;
            }
            String dbCode = ctx.getAIS();
            String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
            String noticeOpenBill = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "noticeOpenBill", "");
            List<Message> messages = WFNoticeHandler.parseMessage(message, eid);
            if (messages != null && messages.size() > 0) {
                Message msg = null;
                for (int i = 0; i < messages.size(); ++i) {
                    msg = messages.get(i);
                    String receivers = msg.getStringHeader("receiver");
                    String[] re = receivers.split(";");
                    for (int j = 0; j < re.length; ++j) {
                        try {
                            IMessageAdapter adapter;
                            String receiver = re[j];
                            IUser user = UserFactory.getLocalInstance((Context)ctx);
                            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(receiver));
                            String userid = userInfo.getId().toString();
                            String procinstId = msg.getStringHeader("ProcessInstId");
                            String assignId = msg.getStringHeader("assignid");
                            ArrayList<IMessageAdapter> passlist = new ArrayList<IMessageAdapter>();
                            MsgType type = MsgType.getEnum((int)message.getIntHeader("type"));
                            MsgBizType bizType = MsgBizType.getEnum((int)message.getIntHeader("bizType"));
                            if (type.equals((Object)MsgType.NOTICE) && bizType == MsgBizType.URGENT) {
                                adapter = new WFUrgentAdapter(msg);
                                passlist.add(adapter);
                            } else if (msg.getStringHeader("titlel2").indexOf("\u4f20\u9605") > -1) {
                                adapter = new WFPassAdapter(messages.get(i));
                                passlist.add(adapter);
                            } else if (!StringUtils.isEmpty((String)procinstId) && WFNoticeHandler.messageHasBillidConf(msg) && !"false".equals(noticeOpenBill)) {
                                adapter = new WFProcessinstAdapter(msg);
                                passlist.add(adapter);
                            } else if (bizType == MsgBizType.FORWARN && !StringUtils.isEmpty((String)message.getStringHeader("url"))) {
                                adapter = new WFLinkNoticeAdapter(msg);
                                passlist.add(adapter);
                            } else {
                                adapter = new WFNoticeAdapter(msg);
                                passlist.add(adapter);
                            }
                            WFNoticeHandler.saveXTMsg(ctx, userid, procinstId, assignId, passlist);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)"WX Messages :: send erring......go next");
                        }
                    }
                }
                logger.error((Object)"WX Messages :: send ending......");
                return 1;
            }
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)"XT Messages send failed!", (Throwable)e);
            return 1;
        }
    }

    private static void saveXTMsg(Context ctx, String userid, String procinstId, String assignId, List<IMessageAdapter> passlist) {
        String pushType;
        IMessagePusher messagePusher = WFMessagePusherFactory.getWFMessagePusher("");
        Map<String, Object> map = messagePusher.pushNoitceMessage(ctx, passlist);
        if (map == null) {
            return;
        }
        boolean bResultPass = (Boolean)map.get("bResult");
        logger.info((Object)("XT Messages send result :: " + bResultPass));
        String MsgId = (String)map.get("sourceMsgId");
        String string = pushType = "flowCenter".equals(map.get("pushType")) ? "2" : "0";
        if (!(!bResultPass || "".equals(MsgId) || "".equals(procinstId) && "".equals(assignId) && !"2".equals(pushType))) {
            try {
                String sql = " insert into t_assign_xtmsg(msgid,fassignid,fuserid,procinstid,pushtype) values(?,?,?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{MsgId, assignId, userid, procinstId, pushType});
            }
            catch (Exception e) {
                logger.error((Object)("XT Messages :: localException1 " + e.getMessage()));
            }
        }
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private static boolean messageHasBillidConf(Message message) {
        String[] split;
        boolean flag = true;
        String sourceIDs = message.getStringHeader("sourceIDs");
        flag = !StringUtils.isEmpty((String)sourceIDs) ? (split = sourceIDs.split("\\|")) != null && split.length > 2 && !StringUtils.isEmpty((String)split[2]) : false;
        return flag;
    }

    private static List<Message> parseMessage(Message message, String eid) {
        MsgBizType needBizType;
        int i;
        String[] ids;
        ArrayList<Message> messages = new ArrayList<Message>();
        String receivers = message.getStringHeader("receiver");
        MsgType type = MsgType.getEnum((int)message.getIntHeader("type"));
        MsgBizType bizType = MsgBizType.getEnum((int)message.getIntHeader("bizType"));
        logger.info((Object)("XT Messages send bizType===" + bizType));
        String needSendMessageType = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "needSendMessageType", "");
        String notSendMessageType = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "notSendMessageType", "");
        boolean needSend = false;
        if (bizType != MsgBizType.WORKFLOW && bizType != MsgBizType.URGENT && bizType != MsgBizType.FORWARN && bizType != MsgBizType.ASYNCHRONISM) {
            if (!StringUtils.isEmpty((String)needSendMessageType)) {
                ids = needSendMessageType.split(",");
                for (i = 0; i < ids.length; ++i) {
                    needBizType = MsgBizType.getEnum((int)Integer.valueOf(ids[i]));
                    if (needBizType != bizType) continue;
                    needSend = true;
                    break;
                }
            }
            if (!needSend) {
                return null;
            }
        }
        needSend = true;
        if (!StringUtils.isEmpty((String)notSendMessageType)) {
            ids = notSendMessageType.split(",");
            for (i = 0; i < ids.length; ++i) {
                needBizType = MsgBizType.getEnum((int)Integer.valueOf(ids[i]));
                if (needBizType != bizType) continue;
                needSend = false;
                break;
            }
        }
        if (!needSend) {
            return null;
        }
        List<String> receiverIDs = WFNoticeHandler.parseReceivers(receivers);
        int receiverSize = receiverIDs.size();
        if (receiverSize == 0) {
            return null;
        }
        if (receiverSize == 1) {
            if (type.equals((Object)MsgType.NOTICE)) {
                message.setStringHeader("receiver", String.valueOf(receiverIDs.get(0)));
                messages.add(message);
                return messages;
            }
        } else if (type.equals((Object)MsgType.NOTICE)) {
            for (int i2 = 0; i2 < receiverSize; ++i2) {
                Message newMessage = WFNoticeHandler.copyMessage(message);
                newMessage.setStringHeader("receiver", receiverIDs.get(i2).toString());
                messages.add(newMessage);
            }
        }
        return messages;
    }

    private static List<String> parseReceivers(String str) {
        ArrayList<String> receiverIDs = new ArrayList<String>();
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            if (str.indexOf(";") != -1) {
                StringTokenizer stReveivers = null;
                stReveivers = new StringTokenizer(str, ";");
                while (stReveivers.hasMoreTokens()) {
                    receiverIDs.add(stReveivers.nextToken());
                }
            } else {
                receiverIDs.add(str);
            }
        }
        return receiverIDs;
    }

    private static Message copyMessage(Message message) {
        Message newMessage = MessageFactory.newMessage();
        newMessage.setStringHeader("databaseCenter", message.getStringHeader("databaseCenter"));
        newMessage.setStringHeader("solution", message.getStringHeader("solution"));
        newMessage.setStringHeader("receiver", message.getStringHeader("receiver"));
        newMessage.setStringHeader("sourceID", message.getStringHeader("sourceID"));
        newMessage.setStringHeader("sourceIDs", message.getStringHeader("sourceIDs"));
        newMessage.setStringHeader("initiatorId", message.getStringHeader("initiatorId"));
        newMessage.setStringHeader("ProcessInstId", message.getStringHeader("ProcessInstId"));
        newMessage.setStringHeader("activityDefId", message.getStringHeader("activityDefId"));
        newMessage.setStringHeader("ProcessDefId", message.getStringHeader("ProcessDefId"));
        if (!StringUtils.isEmpty((String)message.getStringHeader("url"))) {
            newMessage.setStringHeader("url", message.getStringHeader("url").trim());
        }
        for (int i = 1; i < 4; ++i) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            newMessage.setLocaleStringHeader("title", message.getLocaleStringHeader("title", locale), locale);
            newMessage.setLocaleStringHeader("body", message.getLocaleStringHeader("body", locale), locale);
        }
        return newMessage;
    }

    private static boolean checkShouldHandle(Context ctx) {
        XTServiceConfig configInstance = XTServiceConfig.getInstance();
        ConfigurationItem otherAppItem = configInstance.getConfigurationItem("OtherApp");
        ConfigurationItem multiApp = configInstance.getConfigurationItem("MultiApp");
        String eid = null;
        String host = null;
        try {
            eid = configInstance.getEidByDbCode(ctx.getAIS());
            host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (multiApp != null) {
            return true;
        }
        return !StringUtils.isEmpty((String)eid) && !StringUtils.isEmpty(host) && otherAppItem == null;
    }
}

