/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.message.WFMessageHandler;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LightAppProcessAssistHandler {
    private static final Logger logger = Logger.getLogger(LightAppProcessAssistHandler.class);

    public static void processAssistHandle(AssignmentCreationEvent ed) {
        block11: {
            if (ed != null && !StringUtils.isEmpty((String)ed.assignmentId) && ed.isSendCommon) {
                try {
                    Context ctx = LightAppProcessAssistHandler.getContext(ed.solution, ed.databaseCenter);
                    String dbCode = ctx.getAIS();
                    String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
                    if (ed == null || StringUtils.isEmpty((String)ed.assignmentId) || !ed.isSendCommon || !XTServiceConfig.getInstance().getPubEnabled(eid, "WFMessage") || !LightAppProcessAssistHandler.checkIsSupportProcessAssist(ed)) break block11;
                    TextMessage message = new TextMessage();
                    message.setStringHeader("databaseCenter", ed.databaseCenter);
                    message.setStringHeader("solution", ed.solution);
                    message.setStringHeader("receiver", ed.receiver);
                    message.setStringHeader("assignid", ed.assignmentId);
                    message.setStringHeader("sendId", ed.initiatorId);
                    message.setStringHeader("bizfunction", ed.functionName);
                    Map name = ed.initiatorName;
                    String billID = ed.bizObjId;
                    String billAlias = "";
                    BOSObjectType bostype = null;
                    String pk = "";
                    boolean sendMessage = true;
                    if (billID != null) {
                        bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
                        EntityObjectInfo entityinfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bostype);
                        billAlias = entityinfo.getAlias();
                        pk = entityinfo.getFullName();
                    }
                    message.setStringHeader("billID", billID);
                    String checkSend = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "checkSend", "");
                    if ("true".equals(checkSend) && !StringUtils.isEmpty((String)pk)) {
                        try {
                            String sql = "PK in (select  FISSHOWINMOBILE from t_bill_assign where FISSHOWINMOBILE =0  and FMETADATA'" + pk + "')";
                            IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            if (countRowSet.size() > 0) {
                                sendMessage = false;
                            }
                        }
                        catch (Exception sql) {
                            // empty catch block
                        }
                    }
                    if (sendMessage) {
                        for (int i = 1; i < 4; ++i) {
                            String localString = "L" + i;
                            Locale locale = new Locale(localString);
                            String initiatorName = (String)name.get(locale);
                            String pre = (initiatorName == null ? "" : String.valueOf(initiatorName) + "\u7684") + billAlias;
                            message.setLocaleStringHeader("predetails", pre, locale);
                            message.setLocaleStringHeader("title", (String)ed.titles.get(locale), locale);
                            message.setLocaleStringHeader("body", (String)ed.bodies.get(locale), locale);
                        }
                        if (bostype == null || bostype != null && !bostype.toString().equals("F4C22AF9")) {
                            WFMessageHandler.sendMessageToXT((Message)message, ctx);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Send XT WorkFlow_Message Error:: ", (Throwable)e);
                }
            }
        }
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private static boolean checkIsSupportProcessAssist(AssignmentCreationEvent ed) {
        boolean flag = true;
        try {
            flag = ed.isSupportProcessAssist;
        }
        catch (Throwable e) {
            logger.error((Object)"LightAppProcessAssistHandler no field isSupportProcessAssist !");
        }
        return flag;
    }

    public void execute(AssignmentCreationEvent ed) {
        LightAppProcessAssistHandler.processAssistHandle(ed);
    }
}

