/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.AbstractMessage;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.pa.common.MessageSectionFactory;
import com.kingdee.lightapp.util.StringUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonMessage
extends AbstractMessage {
    private static Logger logger = Logger.getLogger((String)CommonMessage.class.getName());
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";

    public CommonMessage(Context ctx, String eid, IMessageAdapter msg, String pubAcctCode, String pubacckey, String code, boolean toAllUser) throws Exception {
        super(msg, pubAcctCode);
        if (msg == null) {
            throw new NullPointerException("adapter is null");
        }
        MessageTypeEnum type = null;
        MessageModelEnum model = null;
        HashMap<String, Object> headPackage = null;
        HashMap<String, Object> bodyPackage = null;
        String signTime = null;
        List<String> userList = null;
        ArrayList<Map<String, Object>> bodyList = new ArrayList<Map<String, Object>>();
        if (msg.isNeedSendXT()) {
            type = msg.getType();
            model = msg.getModel();
            signTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(msg.getUpdateTime());
            Map<String, Object> m = msg.getContent();
            if (m != null) {
                bodyList.add(m);
            }
            List<String> xtList = this.transferUserIdToXtId(ctx, msg.getUsers());
            logger.info((Object)("CommonMessage === xtList" + xtList.size()));
            for (int j = 0; j < xtList.size(); ++j) {
                logger.info((Object)("CommonMessage === xtList.get(" + j + ")" + xtList.get(j)));
            }
            userList = this.mergeUsers(userList, xtList, toAllUser);
            logger.info((Object)("CommonMessage === userList" + userList.size()));
            for (int k = 0; k < userList.size(); ++k) {
                logger.info((Object)("CommonMessage === xtList.get(" + k + ")" + userList.get(k)));
            }
            if (userList == null || userList.size() < 1) {
                logger.error((Object)"userList is null");
                throw new Exception("nouser");
            }
        }
        try {
            if (bodyList.size() > 0) {
                this.head = MessageSectionFactory.getInstance().getMessageHead("common", eid);
                headPackage = new HashMap<String, Object>();
                headPackage.put("account", pubAcctCode);
                headPackage.put("signtime", signTime);
                headPackage.put("users", userList);
                headPackage.put("pubacckey", pubacckey);
                headPackage.put("code", code);
                this.head.makeContent(headPackage);
                this.body = MessageSectionFactory.getInstance().getMessageBody(type, model);
                bodyPackage = new HashMap();
                if (this.body.isSupportMultiEntries()) {
                    if (bodyList.size() > 1 && model != null) {
                        model = MessageModelEnum.MULTIGRAPHIC;
                    }
                    bodyPackage.put("list", bodyList);
                } else {
                    bodyPackage = msg.getContent();
                }
                this.body.makeContent(bodyPackage);
            } else {
                logger.info((Object)"has found 1 adapter messages,but no message need push");
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("message type is error:" + e.getMessage()));
        }
        catch (NullPointerException e) {
            throw e;
        }
    }

    private List<String> transferUserIdToXtId(Context ctx, List<String> userIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        if (userIdList != null) {
            int pageSize = 900;
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / pageSize + 1;
            for (int i = 0; i < totalPage; ++i) {
                IRowSet rs;
                int firstCount = i * pageSize;
                int maxCount = (i + 1) * pageSize;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtil.isNotEmpty(userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                Object[] params = new Object[1];
                String sql = "select FXtId from T_PM_easxtusermap where FuserId in (" + sb.toString() + ")";
                params[0] = sb.toString();
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    e.printStackTrace();
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                    se.printStackTrace();
                }
                if (xtIdList.size() != 0) continue;
                sql = "select FXtId from T_PM_easxtusermap where FPersonId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    e.printStackTrace();
                    continue;
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                    se.printStackTrace();
                }
            }
        }
        return xtIdList;
    }

    private List<String> mergeUsers(List<String> firstList, List<String> secondList, boolean toAllUser) {
        List<Object> list;
        block5: {
            list = null;
            if (!toAllUser) {
                try {
                    if (firstList == null) {
                        list = secondList;
                        break block5;
                    }
                    list = new ArrayList();
                    list.addAll(firstList);
                    secondList.removeAll(list);
                    list.addAll(secondList);
                }
                catch (Exception e) {
                    logger.error((Object)("the list of user has error:" + e.getMessage()));
                }
            } else {
                list = new ArrayList();
                list.add(PUSH_ALL_USERS);
                logger.info((Object)"push to all user switch has enabled");
            }
        }
        return list;
    }
}

