/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DeadlineDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.AbstractYZJMessage;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.pa.common.MessageSectionFactory;
import com.kingdee.lightapp.pa.common.TodoMessage;
import com.kingdee.lightapp.util.TransferUserIdToXtIdUtil;
import com.kingdee.lightapp.xt.YZJFlowCenterMouldHandler;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class FlowCenterToReadMessage
extends AbstractYZJMessage {
    private static Logger logger = Logger.getLogger((String)TodoMessage.class.getName());

    public FlowCenterToReadMessage(Context ctx, String eid, IMessageAdapter adapter) throws Exception {
        super(adapter);
        if (adapter == null) {
            throw new NullPointerException("adapter is null");
        }
        Map<String, Object> bodyPackage = adapter.getContent();
        String sendUserId = (String)bodyPackage.get("sendId");
        String receiver = (String)bodyPackage.get("receiver");
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(sendUserId);
        userIdList.add(receiver);
        Map<String, String> openIdMap = TransferUserIdToXtIdUtil.transferWithMap4YZJ(ctx, userIdList);
        String sendOpenId = openIdMap.get(sendUserId);
        String reciverOpenid = openIdMap.get(receiver);
        if (StringUtils.isEmpty((String)reciverOpenid)) {
            throw new Exception("nouser");
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo assignment = this.getAssigmentInfo(bodyPackage, svc);
        String procinstid = (String)bodyPackage.get("procinstid");
        String bizObjectId = "";
        String actInstId = "";
        String assignmentId = "";
        String actDefName = "";
        if (assignment == null && !StringUtils.isEmpty((String)procinstid)) {
            bizObjectId = this.getBillIdByProcinstId(ctx, procinstid);
            actInstId = UUID.randomUUID() + "WFATINST";
            assignmentId = UUID.randomUUID() + "WFWKITEM";
            actDefName = "\u6d41\u7a0b\u542f\u52a8\u6d88\u606f";
        } else {
            bizObjectId = assignment.getBizObjectIds();
            actInstId = assignment.getActInstId();
            assignmentId = assignment.getAssignmentId();
            actDefName = assignment.getActDefName(new Locale("L2"));
        }
        procinstid = StringUtils.isEmpty((String)procinstid) ? assignment.getProcInstId() : procinstid;
        String proInstTopic = svc.getProcessInstInfo(procinstid).getInstTopic(new Locale("L2"));
        String typeId = this.getMouldTypeId(ctx, bizObjectId, sendOpenId);
        int urgency = assignment == null ? 1 : this.calculateUrgency(svc, actInstId);
        int ttl = assignment == null ? 0 : this.getdDeadLine(svc, assignment.getAssignmentId());
        logger.error((Object)("FlowCenterTodoMessage urgency\uff1a" + urgency + " ttl\uff1a" + ttl));
        if (adapter.isNeedSendXT()) {
            this.content = MessageSectionFactory.getInstance().getMessageHeadNew("flowcentertoread", eid);
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            contentMap.put("url", bodyPackage.get("url"));
            contentMap.put("appid", bodyPackage.get("appid"));
            contentMap.put("typeId", typeId);
            contentMap.put("urgency", urgency);
            contentMap.put("flowId", procinstid);
            contentMap.put("text", bodyPackage.get("text"));
            contentMap.put("creator", sendOpenId);
            contentMap.put("procDefName", proInstTopic);
            contentMap.put("activityName", actDefName);
            contentMap.put("activityId", actInstId);
            contentMap.put("ttl", ttl);
            contentMap.put("assignId", assignmentId);
            contentMap.put("reciver", reciverOpenid);
            contentMap.put("eid", eid);
            contentMap.put("billdNumber", this.gitBilldNumber(ctx, bizObjectId));
            this.content.makeContent(contentMap);
        }
    }

    private String getBillIdByProcinstId(Context ctx, String procinstid) {
        String qrySql = "SELECT FREFID FROM T_WFR_PROCINSTREF where FTYPE = '1' AND  FPROCINSTID  = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)qrySql, (Object[])new Object[]{procinstid});
            if (rs.next()) {
                return rs.getString("FREFID");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String gitBilldNumber(Context ctx, String billID) {
        String number = "";
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("number");
            number = (String)BotpHelper.getObjectById((Context)ctx, (String)billID, (SelectorItemCollection)selectors).get("number");
        }
        catch (Exception e) {
            logger.error((Object)"gitBilldNumber for yzj error!", (Throwable)e);
        }
        return number;
    }

    private AssignmentInfo getAssigmentInfo(Map<String, Object> bodyPackage, IEnactmentService svc) throws WfException {
        String assignid = (String)bodyPackage.get("assignId");
        String procinstid = (String)bodyPackage.get("procinstid");
        AssignmentInfo assignment = null;
        if (StringUtils.isEmpty((String)assignid)) {
            AssignmentInfo[] assignments = svc.getAssignmentAllByProcInstId(procinstid);
            Timestamp lastStateTime = null;
            for (int i = 0; i < assignments.length; ++i) {
                AssignmentInfo assign = assignments[i];
                if (i == 0) {
                    assignment = assign;
                    lastStateTime = assign.getLastStateTime();
                }
                if (i <= 0 || lastStateTime == null || assign == null || assign.getLastStateTime() == null || !lastStateTime.before(assign.getLastStateTime())) continue;
                assignment = assign;
                lastStateTime = assign.getLastStateTime();
            }
        } else {
            assignment = svc.getAssignmentById(assignid);
        }
        return assignment;
    }

    private int calculateUrgency(IEnactmentService svc, String actInstId) throws WfException, WfKpdlParseException {
        int urgency = 1;
        try {
            ActivityInstInfo aii = svc.getActivityInstByActInstId(actInstId);
            ActivityDef ad = svc.getActDefByActInstInfo(aii);
            int pri = ad.getActivityHeader().getpriority();
            if (pri == 1) {
                urgency = 2;
            } else if (pri == 2) {
                urgency = 3;
            } else if (pri > 2) {
                urgency = 4;
            }
        }
        catch (Exception e) {
            logger.error((Object)"calculateUrgency for yzj error!", (Throwable)e);
        }
        return urgency;
    }

    private int getdDeadLine(IEnactmentService svc, String assignid) throws WfException {
        int ttl = 0;
        Map activityInfoMap = svc.getActivityDefAndActivityInstInfo(assignid);
        ManpowerActivityDef activityDef = (ManpowerActivityDef)activityInfoMap.get("ACTIVITYDEF");
        DeadlineCollection deadlines = activityDef.getDeadlines();
        List list = deadlines.toList();
        for (Object object : list) {
            DeadlineDef deadline = (DeadlineDef)object;
            if (!"ConservationDay".equals(deadline.getTimeMode()) || !deadline.getEventPolicy().isUseActivityParticipants()) continue;
            String deadlineCondition = deadline.getDeadlineCondition();
            int parseDead = this.parseDeadlineCondition(deadlineCondition);
            ttl = parseDead > ttl ? parseDead : ttl;
        }
        return ttl;
    }

    private int parseDeadlineCondition(String condition) {
        int interval = 0;
        if (condition != null) {
            String[] time = StringUtils.split((String)condition, (String)"/");
            int conditionLength = time.length;
            if (time != null && (conditionLength == 5 || conditionLength == 6)) {
                try {
                    Calendar c = Calendar.getInstance();
                    long l = c.getTime().getTime();
                    int year = 0;
                    c.add(1, year);
                    int month = Integer.parseInt(time[conditionLength - 5]);
                    c.add(2, month);
                    int date = Integer.parseInt(time[conditionLength - 4]);
                    c.add(5, date);
                    int hour = Integer.parseInt(time[conditionLength - 3]);
                    c.add(10, hour);
                    int min = Integer.parseInt(time[conditionLength - 2]);
                    c.add(12, min);
                    int sec = Integer.parseInt(time[conditionLength - 1]);
                    c.add(13, sec);
                    Date date1 = c.getTime();
                    interval = (int)((date1.getTime() - l) / 1000L / 60L);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)"\u671f\u9650\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!", (Throwable)e);
                }
            }
        }
        return interval;
    }

    private String getMouldTypeId(Context ctx, String bizObjectId, String sendOpenId) throws Exception {
        String bosType = BOSUuid.read((String)bizObjectId).getType().toString();
        YZJFlowCenterMouldHandler instance = YZJFlowCenterMouldHandler.getInstance();
        String typeId = instance.getMouldTypeId(ctx, bosType);
        if (StringUtils.isEmpty((String)typeId)) {
            typeId = instance.initMould(ctx, bizObjectId, sendOpenId, null);
        }
        return typeId;
    }
}

