/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common.messagebody;

import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.ThumbnailSizeEnum;
import com.kingdee.lightapp.pa.ThumbnailTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageSection;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.image.ImageUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiGraphicMessageBody
implements IMessageSection {
    private static Logger logger = Logger.getLogger((String)MultiGraphicMessageBody.class.getName());
    private Map<String, Object> content = null;

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public void makeContent(Map<String, Object> content) {
        List list = (List)content.get("list");
        if (list != null) {
            Iterator iterator = list.iterator();
            ArrayList partList = new ArrayList();
            boolean isFirstNews = true;
            ThumbnailTypeEnum thumbnailType = ThumbnailTypeEnum.SMALL;
            while (iterator.hasNext()) {
                content = (Map)iterator.next();
                if (isFirstNews) {
                    thumbnailType = ThumbnailTypeEnum.BIG;
                    isFirstNews = false;
                } else {
                    thumbnailType = ThumbnailTypeEnum.SMALL;
                }
                if (content == null || !content.containsKey("date") || !content.containsKey("title") || !content.containsKey("text") || !content.containsKey("name") || !content.containsKey("pic")) continue;
                HashMap part = new HashMap();
                part.put("date", content.get("date"));
                part.put("title", content.get("title"));
                part.put("text", content.get("text"));
                part.put("zip", content.get("zip"));
                part.put("url", content.get("url"));
                part.put("appid", content.get("appid"));
                part.put("name", content.get("name"));
                part.put("pic", this.getMsgThumbnail(content.get("pic").toString(), thumbnailType, FileUtil.getExtension(content.get("name").toString())));
                partList.add(part);
            }
            if (partList.size() > 0) {
                HashMap<String, Serializable> msg = new HashMap<String, Serializable>();
                msg.put("model", Integer.valueOf(MessageModelEnum.MULTIGRAPHIC.value()));
                msg.put("list", partList);
                if (!StringUtils.isEmpty((String)((String)content.get("todo")))) {
                    msg.put("todo", (Serializable)content.get("todo"));
                }
                this.content = new HashMap<String, Object>();
                this.content.put("type", MessageTypeEnum.GRAPHIC.value());
                this.content.put("msg", msg);
            }
        }
    }

    @Override
    public boolean hasReady() {
        if (this.content == null) {
            logger.debug((Object)"message body object is null");
            return false;
        }
        if (!this.content.containsKey("type") || !this.content.containsKey("msg")) {
            logger.debug((Object)"message body fields has not ready");
            return false;
        }
        return true;
    }

    private String getMsgThumbnail(String data, ThumbnailTypeEnum type, String ext) {
        byte[] out = null;
        byte[] in = StringUtil.getByteFromBase64(data);
        String base64 = null;
        switch (type) {
            case BIG: {
                out = ImageUtil.crop(in, ThumbnailSizeEnum.BIG_WIDTH.value(), ThumbnailSizeEnum.BIG_HEIGHT.value(), ext);
                break;
            }
            case SMALL: {
                out = ImageUtil.crop(in, ThumbnailSizeEnum.SMALL_WIDTH.value(), ThumbnailSizeEnum.SMALL_HEIGHT.value(), ext);
            }
        }
        base64 = StringUtil.getBase64FromByte(out);
        return base64;
    }

    @Override
    public boolean isSupportMultiEntries() {
        return true;
    }
}

