/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util.stream;

import com.kingdee.lightapp.util.stream.ByteWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class SectionByteOutputStream
extends OutputStream {
    public static final int DEFAULT_SECTION_LENGTH = 131072;
    private int sectionLength = 131072;
    private ArrayList sections;
    protected int count;

    public SectionByteOutputStream() {
        this(131072);
    }

    public SectionByteOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.init(size);
    }

    void init(int size) {
        int secnum = (size - 1) / this.sectionLength + 1;
        this.sections = new ArrayList(secnum);
        for (int i = 0; i < secnum; ++i) {
            byte[] bytes = new byte[this.sectionLength];
            this.sections.add(new ByteWrapper(bytes));
        }
    }

    void expand(int size) {
        int secnum = this.sections.size();
        int newsecnum = (size - 1) / this.sectionLength + 1;
        for (int i = secnum; i <= newsecnum; ++i) {
            byte[] bytes = new byte[this.sectionLength];
            this.sections.add(new ByteWrapper(bytes));
        }
    }

    void putByte(int index, byte b) {
        int secpos = index / this.sectionLength;
        int bytepos = index % this.sectionLength;
        ByteWrapper bw = (ByteWrapper)this.sections.get(secpos);
        bw.put(bytepos, b);
    }

    void putBytes(byte[] b, int off, int len, int index) {
        int index2 = index + len - 1;
        int secpos1 = index / this.sectionLength;
        int secpos2 = index2 / this.sectionLength;
        int bytepos1 = index % this.sectionLength;
        int bytepos2 = index2 % this.sectionLength;
        if (secpos1 == secpos2) {
            ByteWrapper bw = (ByteWrapper)this.sections.get(secpos1);
            byte[] buf = bw.getBytes();
            System.arraycopy(b, off, buf, bytepos1, len);
        } else {
            int off2 = off;
            for (int i = secpos1; i <= secpos2; ++i) {
                int len2;
                byte[] buf;
                ByteWrapper bw;
                if (i == secpos1) {
                    bw = (ByteWrapper)this.sections.get(i);
                    buf = bw.getBytes();
                    len2 = this.sectionLength - bytepos1;
                    System.arraycopy(b, off2, buf, bytepos1, len2);
                } else if (i == secpos2) {
                    bw = (ByteWrapper)this.sections.get(i);
                    buf = bw.getBytes();
                    len2 = bytepos2 + 1;
                    System.arraycopy(b, off2, buf, 0, len2);
                } else {
                    bw = (ByteWrapper)this.sections.get(i);
                    buf = bw.getBytes();
                    len2 = this.sectionLength;
                    System.arraycopy(b, off2, buf, 0, len2);
                }
                off2 += len2;
            }
        }
    }

    @Override
    public synchronized void write(int b) {
        int newcount = this.count + 1;
        this.expand(newcount);
        this.putByte(this.count, (byte)b);
        this.count = newcount;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        this.expand(newcount);
        this.putBytes(b, off, len, this.count);
        this.count = newcount;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        int len = this.count;
        int secnum = this.sections.size();
        for (int i = 0; i < secnum && len > 0; len -= this.sectionLength, ++i) {
            ByteWrapper bw = (ByteWrapper)this.sections.get(i);
            byte[] buf = bw.getBytes();
            if (len < this.sectionLength) {
                out.write(buf, 0, len);
                continue;
            }
            out.write(buf, 0, this.sectionLength);
        }
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        int len = this.count;
        int secnum = this.sections.size();
        for (int i = 0; i < secnum && len > 0; len -= this.sectionLength, ++i) {
            ByteWrapper bw = (ByteWrapper)this.sections.get(i);
            byte[] buf = bw.getBytes();
            if (len < this.sectionLength) {
                System.arraycopy(buf, 0, newbuf, i * this.sectionLength, len);
                continue;
            }
            System.arraycopy(buf, 0, newbuf, i * this.sectionLength, this.sectionLength);
        }
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.toByteArray(), 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), 0, this.count, enc);
    }

    public String toString(int hibyte) {
        return new String(this.toByteArray(), hibyte, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public int getSectionLength() {
        return this.sectionLength;
    }

    public void setSectionLength(int sectionLength) {
        this.sectionLength = sectionLength;
    }
}

