/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.welink;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.TransferUserIdToXtIdUtil;
import com.kingdee.lightapp.welink.WeLinkAPIInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WeLinkMessagePusher
implements IMessagePusher {
    private final Logger logger = Logger.getLogger(WeLinkMessagePusher.class);
    private String messageType;

    public WeLinkMessagePusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String weLinkClientId = XTServiceConfig.getInstance().getWeLinkClientId(eid);
        for (IMessageAdapter adapter : messageList) {
            String withNotie;
            String msgStr = this.createWeLinkMessageMsg(ctx, eid, weLinkClientId, adapter);
            this.logger.error((Object)("WeLinkMessageMsg=====" + msgStr));
            if (StringUtils.isEmpty((String)msgStr)) continue;
            String pushResult = "";
            Map<String, Object> content = adapter.getContent();
            String assignid = (String)content.get("assignId");
            String userId = (String)content.get("receiver");
            try {
                pushResult = WeLinkAPIInvokeUtil.pushTodoMessage(msgStr, weLinkClientId);
                this.savePushedMsg(ctx, 1, assignid, userId, null, pushResult);
                this.logger.error((Object)("WeLinkMessagePusher==push==re=" + pushResult));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                String error = e.getMessage();
                if (error != null && "Read timed out".equalsIgnoreCase(error.trim())) {
                    String taskID = dbCode + "-" + assignid;
                    String successStr = "{\"code\":\"0\",\"data\":{\"taskId\":\"" + taskID + "\"}}";
                    this.savePushedMsg(ctx, 1, assignid, userId, null, successStr);
                }
                this.insertEror(ctx, assignid, userId, "0", error);
            }
            if (!"true".equals(withNotie = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "withNotie", ""))) continue;
            try {
                msgStr = this.createWeLinkMessageMsg(ctx, eid, weLinkClientId, adapter);
                this.pushNoitceMessage(ctx, messageList);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String weLinkClientId = XTServiceConfig.getInstance().getWeLinkClientId(eid);
        for (IMessageAdapter adapter : messageList) {
            String msgStr = this.createWeLinkNoitceMessageMsg(ctx, eid, weLinkClientId, adapter);
            this.logger.error((Object)("WeLinkMessageMsg=====" + msgStr));
            if (StringUtils.isEmpty((String)msgStr)) continue;
            String pushResult = "";
            Map<String, Object> content = adapter.getContent();
            String assignid = (String)content.get("assignId");
            String userId = (String)content.get("receiver");
            try {
                pushResult = WeLinkAPIInvokeUtil.pushNoticeMessage(msgStr, weLinkClientId);
                userId = (String)content.get("receiver");
                String procinstid = (String)content.get("procinstid");
                this.savePushedMsg(ctx, 2, assignid, userId, procinstid, pushResult);
                this.logger.error((Object)("WeLinkMessagePusher==push==re=" + pushResult));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                this.insertEror(ctx, assignid, userId, "1", e.getMessage());
            }
        }
        return null;
    }

    private void savePushedMsg(Context ctx, int type, String assignid, String userId, String procinstid, String pushResult) {
        JSONObject pushResultObject = JSON.parseObject((String)pushResult);
        String errcode = pushResultObject.getString("code");
        String errmsg = pushResultObject.getString("message");
        if ("0".equals(errcode)) {
            String msgid = "";
            if (type == 1) {
                JSONObject dataObject = pushResultObject.getJSONObject("data");
                msgid = dataObject.getString("taskId");
            } else {
                msgid = procinstid;
            }
            try {
                String sql = " insert into t_assign_wlmsg(msgid,fassignid,fuserid,procinstid,msgtype) values(?,?,?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgid, assignid, userId, procinstid, type});
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
                this.insertEror(ctx, assignid, userId, errcode + "", errmsg + "~" + e.getMessage());
            }
        } else {
            this.insertEror(ctx, assignid, userId, errcode + "", errmsg);
        }
    }

    private void insertEror(Context ctx, String assignid, String userId, String errorcode, String errormsg) {
        try {
            String sql = " insert into t_assign_wlmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"", assignid, userId, errorcode, errormsg});
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private String createWeLinkMessageMsg(Context ctx, String eid, String weLinkClientId, IMessageAdapter adapter) {
        List<String> personIds = adapter.getUsers();
        List<String> useridList = TransferUserIdToXtIdUtil.transferWithList4Welink(ctx, personIds);
        String touser = "";
        if (useridList.size() == 0) {
            return null;
        }
        HashMap map = (HashMap)adapter.getContent();
        String assignid = (String)map.get("assignId");
        String description = (String)map.get("text");
        String easTitle = (String)map.get("title");
        if (!StringUtils.isEmpty((String)easTitle)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + easTitle;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        String appName = XTServiceConfig.getInstance().getWeLinkCorpConfig(eid, "appName");
        appName = StringUtils.isEmpty((String)appName) ? "\u6d41\u7a0b\u52a9\u624b" : appName;
        touser = useridList.get(0);
        String initiatorName = (String)map.get("sendName");
        String userId = (String)adapter.getContent().get("sendId");
        msgMap.put("taskId", ctx.getAIS() + "-" + assignid);
        msgMap.put("taskTitle", description);
        msgMap.put("userId", touser);
        msgMap.put("userNameCn", touser);
        msgMap.put("userNameEn", touser);
        String url = (String)map.get("url");
        msgMap.put("detailsUrl", this.changToWeLinkUrl(url, weLinkClientId));
        msgMap.put("appName", appName);
        msgMap.put("applicantUserId", userId);
        msgMap.put("applicantUserNameCn", initiatorName);
        msgMap.put("applicantUserNameEn", initiatorName);
        msgMap.put("applicantId", weLinkClientId);
        return JSON.toJSONString(msgMap);
    }

    private String createWeLinkNoitceMessageMsg(Context ctx, String eid, String weLinkClientId, IMessageAdapter adapter) {
        List<String> personIds = adapter.getUsers();
        List<String> useridList = TransferUserIdToXtIdUtil.transferWithList4Welink(ctx, personIds);
        String touser = "";
        if (useridList.size() == 0) {
            return null;
        }
        HashMap map = (HashMap)adapter.getContent();
        String assignid = (String)map.get("assignId");
        String description = (String)map.get("text");
        String easTitle = (String)map.get("title");
        if (!StringUtils.isEmpty((String)easTitle)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + easTitle;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        String title = "\u60a8\u6709\u901a\u77e5\u6d88\u606f";
        String wxtitle = (String)map.get("wxtitle");
        if (!StringUtils.isEmpty((String)wxtitle)) {
            title = wxtitle;
        }
        msgMap.put("msgRange", 0);
        msgMap.put("toUserList", useridList);
        msgMap.put("msgTitle", title);
        msgMap.put("msgContent", description);
        if (adapter.getType().value() != 2) {
            msgMap.put("urlType", "html");
            String url = (String)map.get("url");
            msgMap.put("urlPath", this.changToWeLinkUrl(url, weLinkClientId));
        }
        return JSON.toJSONString(msgMap);
    }

    private List<String> getUserAndAutoBind(Context ctx, List personIds, String weLinkClientId) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        String personId = (String)personIds.get(0);
        String sql = "SELECT FNUMBER FROM T_PM_USER where FID = ?";
        try {
            HashMap<String, Object> useridInfo;
            String number = "";
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId});
            if (dataSet.next()) {
                number = dataSet.getString(1);
            } else {
                sql = "SELECT FNUMBER FROM T_PM_USER where FPERSONID = ?";
                dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId});
                if (dataSet.next()) {
                    number = dataSet.getString(1);
                }
            }
            if (!StringUtils.isEmpty((String)number) && (useridInfo = WeLinkAPIInvokeUtil.getUseridInfo(number, weLinkClientId)).get("userId") != null) {
                String wlUserId = (String)useridInfo.get("userId");
                xtIdList.add(wlUserId);
                System.out.println("shr userNumber:" + number + "..welink userId:" + wlUserId);
                this.autoBind(ctx, wlUserId, personId);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return xtIdList;
    }

    private void autoBind(Context ctx, String openid, String userid) {
        String sql = "SELECT FID FROM T_PM_EASWLUSERMAP WHERE FUserID = ? ";
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userid});
            if (dataSet.next()) {
                sql = "UPDATE T_PM_EASWLUSERMAP SET FXTID = ? WHERE FUserID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{openid, userid});
            } else {
                sql = "select fid,  fpersonid, fnumber, fname_l2 from t_pm_user where fid = ?";
                dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userid});
                String fpersonid = null;
                String fnumber = null;
                String fname = null;
                if (dataSet.next()) {
                    fpersonid = dataSet.getString(2);
                    fnumber = dataSet.getString(3);
                    fname = dataSet.getString(4);
                }
                sql = "insert into T_PM_EASWLUSERMAP (fid, fpersonid, fuserid, fxtid, fusernumber,fusername,fpersonname)  values(newbosid('ABCD8899'),?,?,?,?,?,'\u6d88\u606f\u63a8\u9001\u7ed1\u5b9a')";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fpersonid, userid, openid, fnumber, fname});
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"WeLinkMessage autobind error: ", (Throwable)e);
        }
    }

    private Object changToWeLinkUrl(String originalURL, String weLinkClientId) {
        if (StringUtils.isEmpty((String)originalURL)) {
            return null;
        }
        String corpId = XTServiceConfig.getInstance().getWeLinkCorpId();
        String url = "";
        if (originalURL.contains("mbosw/getWorkflowUrl")) {
            url = originalURL.replace("mbosw/getWorkflowUrl", "auth/welink.html");
            url = url + "&replaceUrl=mbosw/getWorkflowUrl";
            url = url + "&welinkClientId=" + weLinkClientId;
        } else {
            url = originalURL.replaceAll("page/loadPage", "auth/welink.html");
            url = url + "&replaceUrl=page/loadPage";
            url = url + "&welinkClientId=" + weLinkClientId;
        }
        url = url + "&code=$(code)";
        return url;
    }
}

