/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeRegister;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgSwitchUtil {
    private static final Logger logger = LoggerFactory.getLogger(OrgSwitchUtil.class);

    public static void switchForLogin(Context ctx) throws EASBizException, BOSException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FullOrgUnitInfo defOrgUnit = currentUserInfo.getDefOrgUnit();
        if (defOrgUnit == null) {
            return;
        }
        String ouId = defOrgUnit.getId().toString();
        OrgTypeRegister.getInstance().initOrgTypeMgrExt();
        HashMap map = (HashMap)ctx.get((Object)"OrgUnits");
        if (map == null) {
            map = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).getOrgs(ouId);
        }
        OrgSwitchUtil.updateSysContext(map, ctx);
    }

    private static void updateSysContext(HashMap map, Context ctx) {
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)orgTypeList.get(i);
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(curOrgType);
            if (orgUnitInfo == null) continue;
            ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgType)curOrgType, (OrgUnitInfo)orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgUnitInfo)ouInfo);
        OrgUnitInfo fiInfo = (OrgUnitInfo)map.get(OrgType.Company);
        if (fiInfo != null) {
            ctx.put((Object)"CompanyInfo", (Object)fiInfo);
            ctx.put((Object)"CurCompanyId", (Object)fiInfo.getId().toString());
        }
        if (CacheConfigManager.getConfig() == null) {
            return;
        }
    }
}

