/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.BOSMsgTypeEnum;
import com.kingdee.eas.mobile.CoreSendMessageCollection;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.PriorityEnum;
import com.kingdee.eas.mobile.SendMobileMessageCollection;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.app.AbstractMessageServerFacadeControllerBean;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.framework.MsgServiceAssistant;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class MessageServerFacadeControllerBean
extends AbstractMessageServerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mobile.app.MessageServerFacadeControllerBean");

    @Override
    protected String[][] _getUnSendMsgs(Context ctx) throws BOSException, EASBizException {
        SendMobileMessageCollection unSendMoMsgs = DefaultSendMoMsgDao.getUnSendMobileMsgs(ctx);
        CoreSendMessageCollection coreSendMsgs = new CoreSendMessageCollection();
        this.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.HIGHT);
        this.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.COMMON);
        this.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.LOW);
        String[][] msgListStrs = null;
        if (coreSendMsgs.size() == 0) {
            return null;
        }
        msgListStrs = new String[coreSendMsgs.size()][13];
        for (int i = 0; i < coreSendMsgs.size(); ++i) {
            CoreSendMessageInfo coreSendMsgInfo = coreSendMsgs.get(i);
            msgListStrs[i][0] = coreSendMsgInfo.getTitle();
            msgListStrs[i][1] = coreSendMsgInfo.getContent();
            msgListStrs[i][2] = coreSendMsgInfo.getMsgID();
            msgListStrs[i][3] = coreSendMsgInfo.getMsgDevType();
            msgListStrs[i][4] = coreSendMsgInfo.isRevertible() + "";
            msgListStrs[i][5] = coreSendMsgInfo.isNotify() + "";
            msgListStrs[i][6] = coreSendMsgInfo.getSentFailNumber() + "";
            msgListStrs[i][7] = coreSendMsgInfo.getAssignID();
            msgListStrs[i][8] = coreSendMsgInfo.getCustomStr();
            msgListStrs[i][12] = coreSendMsgInfo.getId().toString();
            SendMobileMessageInfo sendMoMsgInfo = (SendMobileMessageInfo)coreSendMsgInfo;
            if (sendMoMsgInfo.getAddress() != null) {
                msgListStrs[i][9] = sendMoMsgInfo.getAddress().getReceiveMobileNumber();
            }
            msgListStrs[i][10] = sendMoMsgInfo.isSendHandcraft() + "";
            if (sendMoMsgInfo.getAddress() == null || sendMoMsgInfo.getAddress().getReceiveBizUser() == null || sendMoMsgInfo.getAddress().getReceiveBizUser().getId() == null) continue;
            msgListStrs[i][11] = sendMoMsgInfo.getAddress().getReceiveBizUser().getId().toString();
        }
        return msgListStrs;
    }

    private void addMoMsgsByPriority(CoreSendMessageCollection desCoreMsfs, AbstractObjectCollection srcCoreMsfs, PriorityEnum priority) throws BOSException, EASBizException {
        if (desCoreMsfs == null) {
            desCoreMsfs = new CoreSendMessageCollection();
        } else if (desCoreMsfs.size() >= 100) {
            return;
        }
        if (srcCoreMsfs != null) {
            for (int i = 0; i < srcCoreMsfs.size(); ++i) {
                CoreSendMessageInfo coreSendMessageInfo;
                if (srcCoreMsfs.getObject(i) == null || !(srcCoreMsfs.getObject(i) instanceof CoreSendMessageInfo) || !(coreSendMessageInfo = (CoreSendMessageInfo)srcCoreMsfs.getObject(i)).getPriority().equals((Object)priority)) continue;
                desCoreMsfs.add(coreSendMessageInfo);
                if (desCoreMsfs.size() < 100) continue;
                return;
            }
        }
    }

    @Override
    protected void _onMessage(Context ctx, String[] msgInfo) throws BOSException {
        String title = msgInfo[0];
        boolean notify = "true".equalsIgnoreCase(msgInfo[1]);
        String relativeId = msgInfo[2];
        String content = msgInfo[3];
        String id = msgInfo[4];
        boolean revertible = "true".equalsIgnoreCase(msgInfo[5]);
        boolean isResponsed = "true".equalsIgnoreCase(msgInfo[6]);
        String bizName = msgInfo[7];
        String customId = msgInfo[8];
        int notSended = !StringUtils.isEmpty((String)msgInfo[9]) ? Integer.parseInt(msgInfo[9]) : 0;
        int priority = !StringUtils.isEmpty((String)msgInfo[10]) ? Integer.parseInt(msgInfo[10]) : 0;
        KDMessageType type = !StringUtils.isEmpty((String)msgInfo[11]) ? KDMessageType.create((int)Integer.parseInt(msgInfo[11])) : null;
        int pepeatTimes = !StringUtils.isEmpty((String)msgInfo[12]) ? Integer.parseInt(msgInfo[10]) : 0;
        KDMessageAddress dDMsgAdd = new KDMessageAddress(msgInfo[14], msgInfo[13]);
        if (!StringUtils.isEmpty((String)msgInfo[15])) {
            dDMsgAdd.setLevel(Integer.parseInt(msgInfo[15]));
        }
        KDMessageAddress[] kDMsgAddr = null;
        if (msgInfo.length > 16) {
            int kdLen = (msgInfo.length - 16) / 3;
            kDMsgAddr = new KDMessageAddress[kdLen];
            for (int i = 0; i < kdLen; ++i) {
                kDMsgAddr[i] = new KDMessageAddress(msgInfo[15 + 3 * (i + 1) - 1], msgInfo[15 + 3 * (i + 1) - 2]);
                if (StringUtils.isEmpty((String)msgInfo[15 + 3 * (i + 1)])) continue;
                kDMsgAddr[i].setLevel(Integer.parseInt(msgInfo[15 + 3 * (i + 1)]));
            }
        }
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        msg.setRelativeId(relativeId);
        msg.setContent(content);
        msg.setId(id);
        msg.setResponsed(isResponsed);
        msg.setBizName(bizName);
        msg.setCustomId(customId);
        msg.setNotSended(notSended);
        msg.setPriority(priority);
        msg.setType(type);
        msg.setSender(dDMsgAdd);
        msg.setReceivers(kDMsgAddr);
        logger.info((Object)("ReceiveMessage: " + msg.getTitle()));
        if (!msg.isNotify()) {
            if (msg.getSender() == null) {
                return;
            }
            CoreSendMessageInfo coreSendMessageInfo = null;
            if (!StringUtils.isEmpty((String)msg.getRelativeId())) {
                KDMessageAddress address = msg.getSender();
                if (address == null) {
                    logger.error((Object)("receive message: '" + msg.getTitle() + "' , has none sender"));
                    return;
                }
                if (1 == BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
                    SendMobileMessageInfo theSendMoMsgInfo = DefaultSendMoMsgDao.getSendMoMsgInfoByMsgId(ctx, msg.getRelativeId());
                    if (theSendMoMsgInfo != null && this.isSendHandcraftMsg(theSendMoMsgInfo)) {
                        MsgServiceAssistant.handleForSendHandcraftMsg(ctx, msg, theSendMoMsgInfo);
                        return;
                    }
                    coreSendMessageInfo = theSendMoMsgInfo;
                } else if (2 == BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
                    EmailSendMessageInfo emailSendMessageInfo = DefaultEmailMessageDAO.getEmailSendMsgInfoByMsgId(ctx, msg.getRelativeId());
                    if (emailSendMessageInfo != null) {
                        coreSendMessageInfo = emailSendMessageInfo;
                    }
                } else {
                    logger.error((Object)("ReceiveMessage: " + msg.getTitle() + ", Unsoppurt type\uff01"));
                    return;
                }
            }
            String userId = null;
            try {
                userId = AppMsgUtil.getUserIdByAddress(ctx, msg.getSender());
            }
            catch (BOSException e) {
                logger.error((Object)("ReceiveMessage: " + msg.getTitle() + ", has none send user\uff01"));
                return;
            }
            if (userId == null) {
                logger.info((Object)("ReceiveMessage(in actionForUnPass) : title = " + msg.getTitle() + "; content = " + msg.getContent()));
                return;
            }
            MsgServiceAssistant.handleForSendOrReplyMsg(ctx, msg, userId, coreSendMessageInfo);
        }
    }

    private boolean isSendHandcraftMsg(SendMobileMessageInfo info) {
        return info.isSendHandcraft() && "for.hander".equals(info.getTitle());
    }

    @Override
    protected void _updateSendEmailMsgInfo(Context ctx, String id, boolean isSendSucceed, Timestamp sentTime, boolean isSendFail) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        if (isSendSucceed) {
            String sentTimeStr = sentTime == null ? "" : ",FSentTime=? ";
            updateCommandSQL = "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=1" + sentTimeStr + ",FSendFail=0 where FID=? ";
            params = new Object[]{sentTime, id};
        } else {
            updateCommandSQL = isSendFail ? "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=0,FSendFail=1,FSentFailNumber=FSentFailNumber+1 where FID=? " : "update T_MO_EmailSendMsg set FSent=1,FSendSucceed=0,FSendFail=0,FSentFailNumber=FSentFailNumber+1 where FID=? ";
            params = new Object[]{id};
        }
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    @Override
    protected void _updateSendMoMsgInfo(Context ctx, String id, String msgId) throws BOSException {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)msgId)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        updateCommandSQL = "update T_MO_SendMoMsg set FMsgId = ?  where FID = ?";
        params = new Object[]{msgId, id};
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    @Override
    protected void _updateSendMoMsgInfo2(Context ctx, String id, boolean isSent, boolean isSendSucceed, boolean isSendFail) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        String updateCommandSQL = null;
        Object[] params = null;
        if (!isSent) {
            updateCommandSQL = "update T_MO_SendMoMsg set FSent=0 , FSendSucceed=0  where FID=?";
            params = new Object[]{id};
        } else {
            Timestamp sentTime = new Timestamp(System.currentTimeMillis());
            if (isSendSucceed) {
                updateCommandSQL = "update T_MO_SendMoMsg set FSent=1, FSendSucceed=1, FSentTime=?, FSendFail=0 where FID=? ";
                params = new Object[]{sentTime, id};
            } else {
                updateCommandSQL = isSendFail ? "update T_MO_SendMoMsg set FSent=1,FSendSucceed=0,FSendFail=1,FSentFailNumber=FSentFailNumber+1  where FID=? " : "update T_MO_SendMoMsg set FSent=1,FSendSucceed=0,FSendFail=0,FSentFailNumber=FSentFailNumber+1  where FID=? ";
                params = new Object[]{id};
            }
        }
        DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
    }

    @Override
    protected void _sendFailMessages(Context ctx, String title, String content, String receiver) throws BOSException {
        Message noticeMsg = MsgUtil.createMessage(ctx, receiver, title, content);
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        senderAgent.sendMessage(noticeMsg);
    }
}

