/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.BizFunctionInfo;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.CommandObjectFactory;
import com.kingdee.eas.mobile.CommandObjectInfo;
import com.kingdee.eas.mobile.IMobileMessageQuerySchema;
import com.kingdee.eas.mobile.MessageSubscriptCollection;
import com.kingdee.eas.mobile.MessageSubscriptInfo;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaFactory;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.app.AbstractMessageSubscriptControllerBean;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.mobile.biz.ISendMsgFunction;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MessageSubscriptControllerBean
extends AbstractMessageSubscriptControllerBean {
    private static final Logger logger = Logger.getLogger(MessageSubscriptControllerBean.class);

    @Override
    protected void _submitMessageSubscriptCol(Context ctx, IObjectCollection subscriptCol, String userId) throws BOSException, EASBizException {
        MessageSubscriptCollection subscriptCollection = (MessageSubscriptCollection)subscriptCol;
        DefaultMsgDAO.saveUserSubscript(ctx, subscriptCollection, userId);
    }

    @Override
    protected void _execMessageSubscript(Context ctx, String subscriptID) throws BOSException, EASBizException {
        String oql = "select *, user.*, bizFunction.* where id = '" + subscriptID + "'";
        MessageSubscriptInfo subscriptInfo = (MessageSubscriptInfo)this._getValue(ctx, oql);
        UserInfo userInfo = subscriptInfo.getUser();
        BizFunctionInfo functionInfo = subscriptInfo.getBizFunction();
        String userId = userInfo.getId().toString();
        String functionId = functionInfo.getId().toString();
        String className = functionInfo.getImplClassName();
        try {
            Class<?> bizClass = Class.forName(className);
            Object instance = bizClass.newInstance();
            if (instance instanceof ISendMsgFunction) {
                BizReturnObj returnObj;
                ISendMsgFunction bizInstance = (ISendMsgFunction)instance;
                String[] params = this.getDefaultParams(ctx, userId, functionId);
                String commandObjId = functionInfo.getCommandObj().getId().toString();
                CommandObjectInfo commandInfo = CommandObjectFactory.getLocalInstance(ctx).getCommandObjectInfo((IObjectPK)new ObjectUuidPK(commandObjId));
                String command = commandInfo.getCommandNumber();
                BizFuncParamObj paramObj = new BizFuncParamObj(ctx = this.handleContext(ctx, userInfo), userId, command, params, null, null);
                if (bizInstance.beforeExecSendAction(paramObj) && bizInstance.afterExecSendAction(paramObj, returnObj = bizInstance.executeSendAction(paramObj)) && returnObj != null && returnObj.isMustReply()) {
                    ObjectUuidPK personPK = new ObjectUuidPK(userInfo.getPerson().getId().toString());
                    String cellNumber = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)personPK).getCell();
                    SendMobileMessageInfo mobileMsgInfo = new SendMobileMessageInfo();
                    String messageContent = null;
                    if (returnObj.isSucceed()) {
                        messageContent = returnObj.getReturnText();
                        if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                            messageContent = returnObj.getReturnText();
                            mobileMsgInfo.setTitle(returnObj.getReturnText());
                        } else {
                            messageContent = returnObj.getTitle();
                            mobileMsgInfo.setTitle(returnObj.getTitle());
                        }
                        mobileMsgInfo.setContent(messageContent);
                    } else {
                        messageContent = returnObj.getErrorText();
                        mobileMsgInfo.setContent(returnObj.getErrorText());
                        if (StringUtils.isEmpty((String)returnObj.getTitle())) {
                            messageContent = "Message subscription for error";
                            mobileMsgInfo.setTitle("Message subscription for error");
                        } else {
                            messageContent = returnObj.getTitle();
                            mobileMsgInfo.setTitle(returnObj.getTitle());
                        }
                    }
                    ServerCenter.getInstance(ctx).sendMessageDirect(ctx, messageContent, cellNumber);
                    MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
                    addressInfo.setReceiveMobileNumber(cellNumber);
                    addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(cellNumber)));
                    addressInfo.setReceiveBizUser(userInfo);
                    mobileMsgInfo.setCU(userInfo.getCU());
                    mobileMsgInfo.setAddress(addressInfo);
                    mobileMsgInfo.setSentTime(new Timestamp(System.currentTimeMillis()));
                    mobileMsgInfo.setSendSucceed(true);
                    mobileMsgInfo.setSent(true);
                    IObjectPK pk = DefaultSendMoMsgDao.addNew(ctx, mobileMsgInfo);
                    if (pk == null) {
                        logger.error((Object)"execMessageSubscript error: can't save the subscript message.");
                    }
                }
            } else {
                logger.error((Object)"\u5904\u7406\u77ed\u4fe1\u8ba2\u9605\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u4e1a\u52a1\u529f\u80fd\u5b9e\u73b0\u7c7b\u6ca1\u5b9e\u73b0\u63a5\u53e3ISendMsgFunction\uff01");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Context handleContext(Context ctx, UserInfo userInfo) {
        if (userInfo != null) {
            try {
                Context newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
                newCtx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
                newCtx.setUserName(userInfo.getName());
                ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)userInfo);
                return newCtx;
            }
            catch (CloneNotSupportedException e) {
                return ctx;
            }
        }
        return ctx;
    }

    private String[] getDefaultParams(Context ctx, String userID, String functionID) throws BOSException, EASBizException {
        String condition;
        IMobileMessageQuerySchema iSchema = MobileMessageQuerySchemaFactory.getLocalInstance(ctx);
        MobileMessageQuerySchemaInfo schemaInfo = iSchema.getDefaultSchemaByUserAndFunction(userID, functionID);
        ArrayList<String> paramList = new ArrayList<String>();
        if (schemaInfo != null && !StringUtils.isEmpty((String)(condition = schemaInfo.getQueryCondition()))) {
            String[] entries = condition.split(",");
            for (int i = 0; i < entries.length; ++i) {
                String[] elements = entries[i].split(":");
                paramList.add(elements[1]);
            }
        }
        if (paramList.size() > 0) {
            return paramList.toArray(new String[0]);
        }
        return null;
    }
}

