/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mobile.app.AbstractMobileMessageAddressControllerBean;
import com.kingdee.eas.mobile.util.MobileUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MobileMessageAddressControllerBean
extends AbstractMobileMessageAddressControllerBean {
    @Override
    protected void _updateCellphoneNumberType(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String selectSql = "SELECT FID, FSendMobileNumber, FReceiveMobileNumber FROM T_MO_MoMsgAddress";
        String updateSql = "UPDATE T_MO_MoMsgAddress SET FSendCellNumberType = ?, FReceiveCellNumberType = ? WHERE FID = ?";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            pstmt = conn.prepareStatement(updateSql);
            rs = stmt.executeQuery(selectSql);
            while (rs.next()) {
                String id = rs.getString(1);
                String sendMobileNumber = rs.getString(2);
                String receiveMobileNumber = rs.getString(3);
                if (sendMobileNumber == null && receiveMobileNumber == null) continue;
                int sendNumberType = MobileUtil.getCellphoneNumberType(sendMobileNumber);
                int receiveNumberType = MobileUtil.getCellphoneNumberType(receiveMobileNumber);
                pstmt.setInt(1, sendNumberType);
                pstmt.setInt(2, receiveNumberType);
                pstmt.setString(3, id);
                pstmt.execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                pstmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }
}

