/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.message.IMAGroupOrgFacade;
import com.kingdee.eas.base.message.IMAGroupResolvent;
import com.kingdee.eas.base.message.MAGroupOrgFacadeFactory;
import com.kingdee.eas.base.message.MAGroupResolventCollection;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.SendMessageSchemaInfo;
import com.kingdee.eas.mobile.app.AbstractSendMessageSchemaControllerBean;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SendMessageSchemaControllerBean
extends AbstractSendMessageSchemaControllerBean {
    private Logger logger = Logger.getLogger((String)SendMessageSchemaControllerBean.class.getName());

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SendMessageSchemaInfo schemaInfo = (SendMessageSchemaInfo)model;
        this.checkLength(ctx, schemaInfo);
        this.checkNumberDuplicate(ctx, schemaInfo);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SendMessageSchemaInfo schemaInfo = (SendMessageSchemaInfo)model;
        this.checkLength(ctx, schemaInfo);
        this.checkNumberDuplicate(ctx, schemaInfo);
        super._update(ctx, pk, model);
    }

    private void checkLength(Context ctx, SendMessageSchemaInfo schemaInfo) throws EASBizException, BOSException {
        String receiver = schemaInfo.getReceiver();
        if (receiver.length() > 255) {
            throw new MobileException(MobileException.RECEIVER_TOO_LONG);
        }
        String content = schemaInfo.getContent();
        if (content.length() > 255) {
            throw new MobileException(MobileException.CONTENT_TOO_LONG);
        }
    }

    private void checkNumberDuplicate(Context ctx, SendMessageSchemaInfo schemaInfo) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)schemaInfo.getNumber(), CompareType.EQUALS));
        if (schemaInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)schemaInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new MobileException(MobileException.NUMBER_EXISTS);
        }
    }

    @Override
    protected IObjectValue _getSchemaByNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (this._exists(ctx, filterInfo)) {
            return this._getValue(ctx, "select * where number = '" + number + "'");
        }
        return null;
    }

    @Override
    protected HashMap _sendMessage(Context ctx, IObjectValue schemaInfo) throws BOSException, EASBizException {
        return this.innerSendMessage(ctx, (SendMessageSchemaInfo)schemaInfo);
    }

    @Override
    protected void _sendMessageBySchema(Context ctx, String number, String content) throws BOSException, EASBizException {
        SendMessageSchemaInfo schemaInfo = (SendMessageSchemaInfo)this._getSchemaByNumber(ctx, number);
        if (!StringUtils.isEmpty((String)content)) {
            schemaInfo.setContent(content);
        }
        this.innerSendMessage(ctx, schemaInfo);
    }

    private HashMap innerSendMessage(Context ctx, SendMessageSchemaInfo schemaInfo) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("Message", new Boolean(false));
        result.put("SMS", new Boolean(false));
        result.put("Email", new Boolean(false));
        if (schemaInfo != null) {
            boolean isSendByMessage = schemaInfo.isIsMessage();
            boolean isSendBySMS = schemaInfo.isIsSMS();
            boolean isSendByEmail = schemaInfo.isIsEmail();
            MsgPriority priority = schemaInfo.getMsgPriority();
            if (!(isSendByMessage || isSendBySMS || isSendByEmail)) {
                return result;
            }
            String receivers = schemaInfo.getReceiver().trim().replace(';', ',');
            String receiverNames = this.replaceOrgNameByPersonName(ctx, receivers);
            receiverNames = this.replaceMAGroupNameByPersonName(ctx, receiverNames);
            String content = schemaInfo.getContent();
            if (isSendByMessage) {
                boolean msgResult = this.sendByMessage(ctx, receiverNames, content, priority);
                result.put("Message", new Boolean(msgResult));
            } else {
                result.put("Message", new Boolean(true));
            }
            if (isSendBySMS) {
                boolean smsResult = this.sendBySMS(ctx, receiverNames, content);
                result.put("SMS", new Boolean(smsResult));
            } else {
                result.put("SMS", new Boolean(true));
            }
            if (isSendByEmail) {
                boolean emailResult = this.sendByEmail(ctx, receiverNames, content);
                result.put("Email", new Boolean(emailResult));
            } else {
                result.put("Email", new Boolean(true));
            }
        }
        return result;
    }

    private boolean sendByMessage(Context ctx, String receiverNames, String content, MsgPriority priority) throws BOSException, EASBizException {
        try {
            String userIds = this.getUserIdByName(ctx, receiverNames);
            if (!StringUtils.isEmpty((String)userIds)) {
                String[] ids = userIds.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    Message noticeMsg = MsgUtil.createMessage(ctx, ids[i], content, content, priority);
                    SenderAgent senderAgent = SenderAgent.getSenderAgent();
                    senderAgent.sendMessage(noticeMsg);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"There is an exception in the execution of sendByMessage!", (Throwable)e);
        }
        return true;
    }

    private boolean sendBySMS(Context ctx, String receiverNames, String content) throws BOSException, EASBizException {
        String phoneNumbers = this.getPhoneNumberByName(ctx, receiverNames);
        if (!StringUtils.isEmpty((String)phoneNumbers)) {
            try {
                MsgUtil.newMsgMobileDerect(ctx, false, content, phoneNumbers);
                return true;
            }
            catch (MobileConnectException e) {
                throw new MobileException(MobileException.SEND_SMS_FAIL_CONNECT);
            }
        }
        return false;
    }

    private boolean sendByEmail(Context ctx, String receiverNames, String content) throws BOSException, EASBizException {
        String emailAddress = this.getEmailAddressByName(ctx, receiverNames);
        if (!StringUtils.isEmpty((String)emailAddress)) {
            try {
                MsgUtil.msgMailDerect(ctx, content, content, emailAddress, "", "", null);
                return true;
            }
            catch (MobileConnectException e) {
                throw new MobileException(MobileException.SEND_EMAIL_FAIL_CONNECT);
            }
        }
        return false;
    }

    private String replaceOrgNameByPersonName(Context ctx, String name) throws BOSException {
        String userNames;
        String[] tempNames = name.split(",");
        HashMap<String, String> orgNameToPersonNameMap = new HashMap<String, String>();
        String localedName = null;
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            localedName = "FName_L1";
        } else if (local.equalsIgnoreCase("l2")) {
            localedName = "FName_L2";
        } else if (local.equalsIgnoreCase("l3")) {
            localedName = "FName_L3";
        }
        for (int i = 0; i < tempNames.length; ++i) {
            StringBuffer sql = new StringBuffer("SELECT user1.").append(localedName).append(" FROM T_PM_User user1 JOIN T_ORG_BaseUnit unit ON user1.FDefOrgUnitID = unit.FID").append(" WHERE unit.").append(localedName).append(" = '").append(tempNames[i]).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                userNames = "";
                while (rs.next()) {
                    String userName = rs.getString(1);
                    if (userName == null || userName.equals("")) continue;
                    if (userNames.length() == 0) {
                        userNames = userName;
                        continue;
                    }
                    userNames = userNames + "," + userName;
                }
                if (StringUtils.isEmpty((String)userNames)) continue;
                orgNameToPersonNameMap.put(tempNames[i], userNames);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        String result = new String(name);
        if (!orgNameToPersonNameMap.isEmpty()) {
            for (String orgName : orgNameToPersonNameMap.keySet()) {
                userNames = (String)orgNameToPersonNameMap.get(orgName);
                int index = result.indexOf(orgName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + orgName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + orgName.length());
            }
        }
        return result;
    }

    private String replaceMAGroupNameByPersonName(Context ctx, String name) throws BOSException {
        String[] tempNames = name.split(",");
        HashMap<String, String> maNameToPersonNameMap = new HashMap<String, String>();
        IMAGroupResolvent iGroup = MAGroupResolventFactory.getLocalInstance((Context)ctx);
        IMAGroupOrgFacade iFacade = MAGroupOrgFacadeFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < tempNames.length; ++i) {
            MAGroupResolventCollection groupCol = iGroup.getMAGroupResolventCollection("select id where name = '" + tempNames[i] + "'");
            if (groupCol.size() <= 0) continue;
            MAGroupResolventInfo groupInfo = groupCol.get(0);
            String groupId = groupInfo.getId().toString();
            UserCollection userCol = iFacade.getMAGroupResolventToUser(groupId);
            String userNames = "";
            for (int j = 0; j < userCol.size(); ++j) {
                UserInfo userInfo = userCol.get(j);
                String userName = userInfo.getName();
                if (userName == null || userName.equals("")) continue;
                userNames = userNames.length() == 0 ? userName : userNames + "," + userName;
            }
            if (StringUtils.isEmpty((String)userNames)) continue;
            maNameToPersonNameMap.put(tempNames[i], userNames);
        }
        String result = new String(name);
        if (!maNameToPersonNameMap.isEmpty()) {
            for (String groupName : maNameToPersonNameMap.keySet()) {
                String userNames = (String)maNameToPersonNameMap.get(groupName);
                int index = result.indexOf(groupName);
                if (index > 0) {
                    result = result.substring(0, index) + userNames + result.substring(index + groupName.length());
                    continue;
                }
                if (index != 0) continue;
                result = userNames + result.substring(index + groupName.length());
            }
        }
        return result;
    }

    private String getPhoneNumberByName(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null || name.equals("")) {
            return null;
        }
        String[] tempNames = name.split(",");
        if (tempNames.length == 0) {
            return null;
        }
        String sql = "SELECT FCell FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer cellNumber = new StringBuffer();
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (!rs.next()) continue;
                String tempCellNumber = rs.getString("FCell");
                if (tempCellNumber != null) {
                    tempCellNumber = tempCellNumber.trim();
                }
                if (tempCellNumber == null || tempCellNumber.equals("")) continue;
                if (cellNumber.length() != 0) {
                    cellNumber.append(",");
                }
                cellNumber.append(tempCellNumber);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return cellNumber.toString();
    }

    private String getEmailAddressByName(Context ctx, String names) throws BOSException, EASBizException {
        if (names == null || names.equals("")) {
            return null;
        }
        String[] tempNames = names.split(",");
        if (tempNames.length == 0) {
            return null;
        }
        String sql = "SELECT FEMail FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer emailAddress = new StringBuffer();
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (!rs.next()) continue;
                String tempEmailAddress = rs.getString("FEMail");
                if (tempEmailAddress != null) {
                    tempEmailAddress = tempEmailAddress.trim();
                }
                if (tempEmailAddress == null || tempEmailAddress.equals("")) continue;
                if (emailAddress.length() != 0) {
                    emailAddress.append(",");
                }
                emailAddress.append(tempEmailAddress);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return emailAddress.toString();
    }

    private String getUserIdByName(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null || name.equals("")) {
            return null;
        }
        String[] tempNames = name.split(",");
        if (tempNames.length == 0) {
            return null;
        }
        String sql = "SELECT FID FROM T_PM_User ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer userIds = new StringBuffer();
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                String id;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (!rs.next() || (id = rs.getString("FID")) == null || id.equals("")) continue;
                if (userIds.length() != 0) {
                    userIds.append(",");
                }
                userIds.append(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return userIds.toString();
    }

    @Override
    protected String _getUserIdsByNames(Context ctx, String names) throws BOSException, EASBizException {
        names = names.trim().replace(';', ',');
        return this.getUserIdByName(ctx, names);
    }

    @Override
    protected String _checkPhoneNumberExists(Context ctx, String receivers) throws BOSException, EASBizException {
        if (receivers == null || receivers.equals("")) {
            return null;
        }
        receivers = receivers.trim().replace(';', ',');
        String receiverNames = this.replaceOrgNameByPersonName(ctx, receivers);
        String[] tempNames = (receiverNames = this.replaceMAGroupNameByPersonName(ctx, receiverNames)).split(",");
        if (tempNames.length == 0) {
            return null;
        }
        String sql = "SELECT FCell FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer personNames = new StringBuffer();
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                String tempCellNumber;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (rs.next() && !StringUtils.isEmpty((String)(tempCellNumber = rs.getString("FCell")))) continue;
                if (personNames.length() != 0) {
                    personNames.append(",");
                }
                personNames.append(tempNames[i]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personNames.toString();
    }

    @Override
    protected String _checkEmailExists(Context ctx, String receivers) throws BOSException, EASBizException {
        if (receivers == null || receivers.equals("")) {
            return null;
        }
        receivers = receivers.trim().replace(';', ',');
        String receiverNames = this.replaceOrgNameByPersonName(ctx, receivers);
        String[] tempNames = (receiverNames = this.replaceMAGroupNameByPersonName(ctx, receiverNames)).split(",");
        if (tempNames.length == 0) {
            return null;
        }
        String sql = "SELECT FEMail FROM T_BD_Person ";
        String appendSql = "";
        String local = ctx.getLocale().toString();
        if (local.equalsIgnoreCase("l1")) {
            appendSql = " WHERE FName_L1 = ? ";
        } else if (local.equalsIgnoreCase("l2")) {
            appendSql = " WHERE FName_L2 = ? ";
        } else if (local.equalsIgnoreCase("l3")) {
            appendSql = " WHERE FName_L3 = ? ";
        }
        sql = sql + appendSql;
        StringBuffer personNames = new StringBuffer();
        try {
            int num = tempNames.length;
            for (int i = 0; i < num; ++i) {
                String tempEMail;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempNames[i]});
                if (rs.next() && !StringUtils.isEmpty((String)(tempEMail = rs.getString("FEMail")))) continue;
                if (personNames.length() != 0) {
                    personNames.append(",");
                }
                personNames.append(tempNames[i]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personNames.toString();
    }
}

