/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.convert.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.convert.Convert;
import com.kingdee.eas.mobile.convert.DecodeException;
import org.apache.log4j.Logger;

public class UserInfoConvert
implements Convert {
    private static final Logger LOGGER = Logger.getLogger(UserInfoConvert.class);

    @Override
    public boolean canProcess(Class<?> clazz) {
        return UserInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object obj) {
        CoreBaseInfo info = (CoreBaseInfo)obj;
        return info.getId().toString();
    }

    @Override
    public Object decode(String text) throws DecodeException {
        try {
            return DynamicObjectFactory.getRemoteInstance().getValue(new UserInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(text));
        }
        catch (Exception e) {
            String errorMsg = String.format("Mobile query solution convert to UserInfo error. Error message:%s", e.getMessage());
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new DecodeException(errorMsg, e);
        }
    }
}

