/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.framework.AbastractMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.MobileMsgInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class NewKingdeeMobileGatewayProvider
extends AbastractMobileGatewayProvider {
    private static final Logger logger = Logger.getLogger(NewKingdeeMobileGatewayProvider.class);

    @Override
    protected boolean _testConnection(MobileConfigInfo mobileConfigInfo) throws EASBizException, BOSException {
        String responseStr = null;
        try {
            responseStr = this.sendRequest2Gateway("queryBalance", "&type=0", mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider-testConnection error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(responseStr));
        }
        catch (JDOMException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String returnCodeStr = doc.getRootElement().getChildText("returnCode");
        BigDecimal balance = new BigDecimal(0);
        if ("1".equals(returnCodeStr) || "undefine_error".equals(returnCodeStr)) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider queryBalance error, response content:" + responseStr));
            throw new EASBizException(MobileException.USER_NOT_EXIST);
        }
        if ("0".equals(returnCodeStr)) {
            List lstElement = doc.getRootElement().getChild("feeResult").getChildren();
            for (int i = 0; i < lstElement.size(); ++i) {
                Element elm = (Element)lstElement.get(i);
                String balanceStr = elm.getChildText("big-decimal");
                logger.debug((Object)("Balance " + elm.getChildText("string") + ": " + balanceStr));
                balance = balance.add(new BigDecimal(balanceStr));
            }
            if (balance.compareTo(new BigDecimal(0)) < 1) {
                logger.warn((Object)"NewKingdeeMobileGatewayProvider-testConnection: no balance!");
                logger.info((Object)responseStr);
                throw new EASBizException(MobileException.GATAWAY_NO_BALANCE);
            }
            logger.info((Object)("NewKingdeeMobileGatewayProvider-testConnection OK, account balance:" + balance));
            return true;
        }
        if ("-150".equals(returnCodeStr)) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider queryBalance error, returnCodeStr(-150):" + responseStr));
            throw new EASBizException(MobileException.GATEWAY_USERNAME_PASSWORD_ERROR);
        }
        return false;
    }

    @Override
    protected String _displayBalance(MobileConfigInfo mobileConfigInfo) throws EASBizException, BOSException {
        String responseStr = null;
        try {
            responseStr = this.sendRequest2Gateway("queryBalance", null, mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider-testConnection error:" + e));
            throw new BOSException((Throwable)e);
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(responseStr));
        }
        catch (JDOMException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String returnCodeStr = doc.getRootElement().getChildText("returnCode");
        BigDecimal balance = new BigDecimal(0);
        if ("1".equals(returnCodeStr) || "undefine_error".equals(returnCodeStr)) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider queryBalance error, response content:" + responseStr));
            throw new EASBizException(MobileException.USER_NOT_EXIST);
        }
        if ("0".equals(returnCodeStr)) {
            List lstElement = doc.getRootElement().getChild("feeResult").getChildren();
            for (int i = 0; i < lstElement.size(); ++i) {
                Element elm = (Element)lstElement.get(i);
                String balanceStr = elm.getChildText("big-decimal");
                logger.debug((Object)("Balance " + elm.getChildText("string") + ": " + balanceStr));
                balance = balance.add(new BigDecimal(balanceStr));
            }
            balance = balance.setScale(2);
            return EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"balanceTip2") + balance.toString();
        }
        return EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"balanceTipContactAdmin");
    }

    @Override
    protected boolean _sendMessage(MobileMsgInfo mobileMsgInfo, MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException, EASBizException {
        StringBuffer queryStringBuffer = new StringBuffer();
        queryStringBuffer.append("&mobileNum=").append(mobileMsgInfo.getReceiverPhoneNo().trim()).append("&content=");
        try {
            String encodeContent = URLEncoder.encode(mobileMsgInfo.getContent(), "UTF-8");
            queryStringBuffer.append(encodeContent);
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Object)("sendMessage4Common UnsupportedEncodingException:" + e1));
        }
        queryStringBuffer.append("&callback=1&callNumber=").append(mobileMsgInfo.getMsgIdInGateway()).append("&channelNum=seil&sysCode=EASDX$101127$80000091");
        String responseStr = null;
        try {
            responseStr = this.sendRequest2Gateway("sendSmsOpen", queryStringBuffer.toString(), mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider-sendMessage4Common error:" + e));
        }
        logger.debug((Object)("NewKingdeeMobileGatewayProvider sendMessage result:" + responseStr));
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(responseStr));
        }
        catch (JDOMException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String returnCodeStr = doc.getRootElement().getChildText("returnCode");
        if ("0".equals(returnCodeStr)) {
            return true;
        }
        logger.error((Object)("NewKingdeeMobileGatewayProvider sendMessage error:" + responseStr));
        return false;
    }

    @Override
    protected String getMsgIdInGateway(SendMobileMessageInfo sendMoMsgInfo, Context ctx) {
        if (sendMoMsgInfo != null) {
            logger.debug((Object)("NewKingdeeMobileGatewayProvider-getMsgIdInGateway return FMsgID:" + sendMoMsgInfo.getMsgID()));
            return sendMoMsgInfo.getMsgID();
        }
        logger.debug((Object)"NewKingdeeMobileGatewayProvider-getMsgIdInGateway return empty string.");
        return "";
    }

    @Override
    protected MobileMsgInfo[] _receiveMessage(MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException {
        StringBuffer queryStringBuffer = new StringBuffer("&channelNum=seil&sysCode=EASDX$101127$80000091");
        String responseStr = null;
        try {
            responseStr = this.sendRequest2Gateway("getNewMoMessage", queryStringBuffer.toString(), mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider-receiveMessage error." + e));
        }
        if (!StringUtil.isEmpty((String)responseStr)) {
            SAXBuilder builder = new SAXBuilder();
            Document doc = null;
            try {
                doc = builder.build((Reader)new StringReader(responseStr));
            }
            catch (JDOMException e) {
                logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"NewKingdeeMobileGatewayProvider read xml error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            String returnCodeStr = doc.getRootElement().getChildText("returnCode");
            String countStr = doc.getRootElement().getChildText("count");
            if (!"0".equals(returnCodeStr) || "undefine_error".equals(returnCodeStr)) {
                logger.info((Object)("NewKingdeeMobileGatewayProvider-receiveMessage gateway error:" + responseStr));
                return null;
            }
            if ("0".equals(countStr)) {
                logger.info((Object)"NewKingdeeMobileGatewayProvider-receiveMessage no message unread.");
                return null;
            }
            List lstElement = doc.getRootElement().getChild("messages").getChildren();
            MobileMsgInfo[] mobileMsgInfos = new MobileMsgInfo[lstElement.size()];
            for (int i = 0; i < lstElement.size(); ++i) {
                Element elm = (Element)lstElement.get(i);
                String callNumber = elm.getChildText("callNumber");
                String targetNumber = elm.getChildText("targetNumber");
                String content = elm.getChildText("content");
                mobileMsgInfos[i] = new MobileMsgInfo(null, content, targetNumber, callNumber);
            }
            return mobileMsgInfos;
        }
        return null;
    }

    private String sendRequest2Gateway(String actionName, String queryString, MobileConfigInfo mobileConfigInfo) throws IOException {
        StringBuffer htmlBuff = new StringBuffer();
        boolean isPortEmpty = StringUtils.isEmpty((String)mobileConfigInfo.getPort());
        StringBuffer urlStr = new StringBuffer("http://").append(mobileConfigInfo.getHost()).append(isPortEmpty ? "" : ":" + mobileConfigInfo.getPort()).append("/api/portal.do?action=").append(actionName).append("&userName=").append(mobileConfigInfo.getLoginName()).append("&password=").append(mobileConfigInfo.getPassword());
        if (queryString != null) {
            urlStr.append(queryString);
        }
        BufferedReader inBuff = null;
        try {
            URL url = new URL(urlStr.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            inBuff = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            if (null != inBuff) {
                String inputLine;
                while ((inputLine = inBuff.readLine()) != null) {
                    htmlBuff.append(inputLine);
                }
            }
        }
        catch (MalformedURLException ue) {
            logger.error((Object)("NewKingdeeMobileGatewayProvider-sendRequest2Gateway:" + ue.getMessage() + "|urlStr:" + urlStr));
            throw ue;
        }
        catch (IOException ie) {
            logger.error((Object)"NewKingdeeMobileGatewayProvider-sendRequest2Gateway IO error:", (Throwable)ie);
            throw ie;
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException ce) {
                    logger.error((Object)"NewKingdeeMobileGatewayProvider-sendRequest2Gateway IO close error:", (Throwable)ce);
                    throw ce;
                }
            }
        }
        return htmlBuff.toString();
    }
}

