/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.swing.plaf.ComponentUI;

public class CheckLicense {
    public static final String MOBILE_PKG = "com.kingdee.eas.mobile.client.BizConfigUI";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.";

    public static int checkMobileLicence(Context ctx, String pkg) throws LicenseException, LoginException {
        LicenseUserInfo licenseUserInfo = CheckLicense.createLicenseUserInfo(ctx.getClientHostIP(), ctx);
        int result = LicenseSrvFactory.getInstance().requestLicense(licenseUserInfo, pkg);
        Locale local = null;
        if (ctx != null) {
            local = ctx.getLocale();
        }
        if (result == 4) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid", (Locale)local));
        }
        if (result == 2) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS", (Locale)local));
        }
        return result;
    }

    public static LicenseUserInfo createLicenseUserInfo(String clientIP, Context ctx) {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(clientIP);
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }

    public static String constructMessage(String className, ComponentUI ui) throws Exception {
        LicenseController lc = FrameWorkClientUtils.getLicenseController();
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append(className);
        buffer.append("\n");
        buffer.append(CheckLicense.constructLicenseMessage(lc, className));
        return buffer.toString();
    }

    public static final String constructLicenseMessage(LicenseController lc, String className) throws LicenseException {
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName"));
        String moduleName = lc.getModuleByPackage(className);
        if (moduleName == null || moduleName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
        }
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SubSystem"));
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

