/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.openapi.IPrivacyOperate;
import com.kingdee.bos.openapi.IPrivacySolution;
import com.kingdee.bos.openapi.PrivacyOperateFactory;
import com.kingdee.bos.openapi.PrivacyOperateInfo;
import com.kingdee.bos.openapi.PrivacyOperateType;
import com.kingdee.bos.openapi.PrivacySolutionFactory;
import com.kingdee.bos.openapi.PrivacySolutionInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;

public class PrivacyOperateUtils {
    public static IObjectPK beginAdd(Context ctx, String detail) {
        return PrivacyOperateUtils.begin(ctx, null, PrivacyOperateType.ADD, detail);
    }

    public static IObjectPK beginModify(Context ctx, String detail) {
        return PrivacyOperateUtils.begin(ctx, null, PrivacyOperateType.MODIFY, detail);
    }

    public static IObjectPK beginUpdateEncryptor(Context ctx, String detail) {
        return PrivacyOperateUtils.begin(ctx, null, PrivacyOperateType.UPDATEENCRYPTOR, detail);
    }

    public static IObjectPK beginDelete(Context ctx, String solutionId) {
        return PrivacyOperateUtils.begin(ctx, solutionId, PrivacyOperateType.DELETE, null);
    }

    public static IObjectPK beginUpdateEncrypteKey(Context ctx, String solutionId) {
        return PrivacyOperateUtils.begin(ctx, solutionId, PrivacyOperateType.UPDATEYENCRYPTKEY, null);
    }

    public static IObjectPK beginExecute(Context ctx, String solutionId) {
        return PrivacyOperateUtils.begin(ctx, solutionId, PrivacyOperateType.EXECUTE, null);
    }

    private static IObjectPK begin(Context ctx, String solutionId, PrivacyOperateType type, String detail) {
        try {
            IPrivacyOperate privacyOperate = PrivacyOperateFactory.getLocalInstance(ctx);
            PrivacyOperateInfo info = new PrivacyOperateInfo();
            info.setType(type);
            if (!StringUtils.isEmpty((String)solutionId)) {
                try {
                    IPrivacySolution privacySolution = PrivacySolutionFactory.getLocalInstance(ctx);
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add("id");
                    selectors.add("name");
                    selectors.add("number");
                    PrivacySolutionInfo privacySolutionInfo = privacySolution.getPrivacySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId), selectors);
                    if (privacySolutionInfo != null) {
                        detail = "\u65b9\u6848\u540d\u79f0\uff1a" + privacySolutionInfo.getName();
                    }
                }
                catch (Throwable ignore) {
                    detail = ignore.getMessage();
                }
            }
            info.setDetail(detail);
            info.setCreatorId(ctx.getCaller().toString());
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setClientIp(ctx.getClientHostIP());
            return privacyOperate.addnew(info);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void end(Context ctx, IObjectPK operateId) throws BOSException {
        try {
            if (operateId == null) {
                return;
            }
            IPrivacyOperate privacyOperate = PrivacyOperateFactory.getLocalInstance(ctx);
            privacyOperate.updateResult(operateId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void endExecuteDetail(Context ctx, IObjectPK operateId, String detail) throws BOSException {
        try {
            if (operateId == null) {
                return;
            }
            IPrivacyOperate privacyOperate = PrivacyOperateFactory.getLocalInstance(ctx);
            PrivacyOperateInfo info = new PrivacyOperateInfo();
            info.setId(BOSUuid.read((String)operateId.toString()));
            info.setDetail(detail);
            privacyOperate.update(operateId, info);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

