/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.openapi.util.ClassUtil;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.openapi.util.json.JSONUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public enum DataType {
    JSON{

        @Override
        public <T> T parse2Object(Context ctx, String str, Class<T> clazz) {
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            try {
                if (ctx == null) {
                    return (T)JSONObject.parseObject((String)str, clazz);
                }
                return JSONUtils.convertJsonToObject(ctx, str, clazz);
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String parse2String(Context ctx, Object obj) {
            if (obj == null) {
                return null;
            }
            if (ctx == null) {
                return JSONUtils.convertObjectToJson(obj);
            }
            try {
                return JSONUtils.convertObjectToJson(ctx, obj);
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object[] handleStr2Param(Context ctx, String dataStr, ParameterCollection pc, String[] clazzs) throws BOSException, Exception, ClassNotFoundException {
            Object[] args = new Object[pc.size()];
            JSONArray data = JSONObject.parseArray((String)dataStr);
            Class genericClazz = null;
            for (int i = 0; i < clazzs.length; ++i) {
                JSONArray jsonArray;
                Class<?> objectValueClass;
                String className = clazzs[i];
                if (!StringUtils.isEmpty((String)className) && className.toString().contains("<")) {
                    try {
                        String typeT = null;
                        String typeP = className.substring(0, className.indexOf("<"));
                        typeT = className.substring(className.indexOf("<") + 1, className.lastIndexOf(">"));
                        genericClazz = ClassUtil.getClassByName(typeT);
                        className = typeP;
                    }
                    catch (Exception e) {
                        throw new Exception("please check your openapi params: " + className + " is wrong,generic can't be null!", e);
                    }
                }
                if (IObjectValue.class.isAssignableFrom(objectValueClass = ClassUtil.getClassByName(className))) {
                    String paramBosType = null;
                    JSONObject object = (JSONObject)data.get(i);
                    if (object == null) {
                        args[i] = null;
                        continue;
                    }
                    paramBosType = object.getString("bosType");
                    if (!StringUtils.isEmpty((String)paramBosType)) {
                        objectValueClass = OpenApiBOUtils.getBizObjectValueClass(ctx, BOSObjectType.create((String)paramBosType));
                    }
                } else if (IObjectCollection.class.isAssignableFrom(objectValueClass) && (jsonArray = data.getJSONArray(i)) != null && jsonArray.size() > 0) {
                    JSONObject jsonObject = jsonArray.getJSONObject(0);
                    String bosType = jsonObject.getString("bosType");
                    if (bosType == null) {
                        throw new Exception("bosType is null,please check you data!");
                    }
                    EntityObjectInfo entityObjectInfo = DataType.getEntityInfo(ctx, BOSObjectType.create((String)bosType));
                    objectValueClass = Class.forName(entityObjectInfo.getObjectCollectionClass());
                }
                if (objectValueClass == String.class) {
                    args[i] = data.getString(i);
                    continue;
                }
                Type type = null;
                type = genericClazz != null ? this.buildType(objectValueClass, genericClazz) : objectValueClass;
                args[i] = JSONUtils.convertJsonToObject(ctx, data.getString(i), type);
            }
            return args;
        }

        private ParameterizedType buildType(final Class<?> raw, final Type ... args) {
            return new ParameterizedType(){

                @Override
                public Type getRawType() {
                    return raw;
                }

                @Override
                public Type[] getActualTypeArguments() {
                    return args;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
        }
    }
    ,
    XML{

        @Override
        public <T> T parse2Object(Context ctx, String str, Class<T> clazz) {
            return null;
        }

        @Override
        public String parse2String(Context ctx, Object obj) {
            return null;
        }

        @Override
        public Object[] handleStr2Param(Context ctx, String dataStr, ParameterCollection pc, String[] clazzs) throws BOSException, Exception, ClassNotFoundException {
            return null;
        }
    };


    public abstract <T> T parse2Object(Context var1, String var2, Class<T> var3);

    public abstract String parse2String(Context var1, Object var2);

    public abstract Object[] handleStr2Param(Context var1, String var2, ParameterCollection var3, String[] var4) throws BOSException, Exception, ClassNotFoundException;

    private static EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        return entityInfo;
    }
}

