/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.utils;

import com.kingdee.bos.openapi.third.utils.Base64;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OpenApiTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String httpUrl, Map<String, String> headers, int connectionTimeout, int readTimeout) throws Exception {
        String result = null;
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(connectionTimeout);
            connection.setReadTimeout(readTimeout);
            connection.setRequestProperty("Context-Type", "application/x-www-form-urlencoded");
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    connection.setRequestProperty(key, String.valueOf(headers.get(key)));
                }
            }
            connection.connect();
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
            } else {
                System.out.println("http invoke error, and http status is " + connection.getResponseCode());
                is = connection.getErrorStream();
            }
            br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            StringBuffer data = new StringBuffer();
            String temp = null;
            while ((temp = br.readLine()) != null) {
                data.append(temp);
                data.append("\r\n");
            }
            result = data.toString();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static String doPost(String httpUrl, Map<String, String> headers, String reqData, int connectionTimeout, int readTimeout) throws Exception {
        HttpURLConnection connection = null;
        FilterOutputStream out = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(connectionTimeout);
            connection.setReadTimeout(readTimeout);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.addRequestProperty("Content-Type", "multipart/form-data");
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    connection.setRequestProperty(key, String.valueOf(headers.get(key)));
                }
            }
            connection.connect();
            out = new DataOutputStream(connection.getOutputStream());
            out.write(reqData.getBytes("utf-8"));
            out.close();
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
            } else {
                System.out.println("http invoke error, and http status is " + connection.getResponseCode());
                is = connection.getErrorStream();
            }
            br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            StringBuffer data = new StringBuffer();
            String temp = null;
            while ((temp = br.readLine()) != null) {
                data.append(temp);
                data.append("\r\n");
            }
            String string = data.toString();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String sha1(String data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(data.getBytes("utf-8"));
        byte[] messageDigest = digest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexString.append(0);
            }
            hexString.append(shaHex);
        }
        return hexString.toString();
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("utf-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("utf-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim() == "";
    }

    public static String generateKGSSignature(String method, String url, String paramStr, String nonce, long ts, String secret) throws Exception {
        String srcStr = method + "\n" + URLEncoder.encode(url, "utf-8") + "\n" + paramStr + "\nx-api-nonce:" + nonce + "\nx-api-timestamp:" + ts + "\n";
        return Base64.encodeBytes(OpenApiTools.HMACSHA256(srcStr, secret).getBytes(), false);
    }
}

