/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.ServerConfigServiceInitializer;
import com.kingdee.bos.framework.PluginMethodProviderManager;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;

public class OpenApiBOUtils {
    public static Object callMethod(Context ctx, BOSObjectType bosType, MethodInfo method, Object[] args) throws Exception {
        Class[] parameterTypes = null;
        if (method == null) {
            return null;
        }
        ParameterCollection pc = method.getParameters();
        parameterTypes = new Class[pc.size() + 1];
        parameterTypes[0] = Context.class;
        for (int i = 0; i < pc.size(); ++i) {
            TypeReference tr = pc.get(i).getParameterType();
            String className = null;
            if (tr.getArrayDimension() == 0) {
                className = tr.toString();
            } else {
                className = "";
                for (int j = 0; j < tr.getArrayDimension(); ++j) {
                    className = className + "[";
                }
                if (tr.isSimpleType()) {
                    String type = tr.getArrayElementType().getBaseType();
                    if (type.equalsIgnoreCase("byte")) {
                        className = className + "B";
                    } else if (type.equalsIgnoreCase("char")) {
                        className = className + "C";
                    } else if (type.equalsIgnoreCase("double")) {
                        className = className + "D";
                    } else if (type.equalsIgnoreCase("float")) {
                        className = className + "F";
                    } else if (type.equalsIgnoreCase("int")) {
                        className = className + "I";
                    } else if (type.equalsIgnoreCase("long")) {
                        className = className + "J";
                    } else if (type.equalsIgnoreCase("short")) {
                        className = className + "S";
                    } else if (type.equalsIgnoreCase("boolean")) {
                        className = className + "Z";
                    }
                } else {
                    className = className + "L" + tr.getArrayElementType() + ";";
                }
            }
            parameterTypes[i + 1] = "short".equals(className) ? Short.TYPE : ("int".equals(className) ? Integer.TYPE : ("long".equals(className) ? Long.TYPE : ("float".equals(className) ? Float.TYPE : ("double".equals(className) ? Double.TYPE : ("char".equals(className) ? Character.TYPE : ("byte".equals(className) ? Byte.TYPE : ("boolean".equals(className) ? Boolean.TYPE : Class.forName(className))))))));
        }
        Object[] args2 = new Object[parameterTypes.length];
        args2[0] = ctx;
        for (int i = 0; i < args.length; ++i) {
            args2[i + 1] = args[i];
        }
        BizController bc = OpenApiBOUtils.getBusinessController(ctx, bosType);
        try {
            Method md = bc.getClass().getMethod(method.getName(), parameterTypes);
            return md.invoke((Object)bc, args2);
        }
        catch (NoSuchMethodException nsm) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(bosType);
            return OpenApiBOUtils.callDepMethod(bo, method, args2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callDepMethod(BusinessObjectInfo bo, MethodInfo method, Object[] args) throws ServiceExecutionException, BOSException {
        if (PluginMethodProviderManager.getProvider() == null) {
            return null;
        }
        try {
            ServiceContext svcCtx = new ServiceContext(bo.getBOSType(), bo.getType(), (IMetaDataPK)MetaDataPK.create((String)method.getInnerID()), args);
            OpenApiBOUtils.invokeServiceBefore(svcCtx);
            OpenApiBOUtils.invokeServiceAfter(svcCtx);
            Object object = svcCtx.getMethodReturnValue();
            return object;
        }
        finally {
            ServiceStateManager.getInstance().finishCall();
        }
    }

    private static void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.getInstance().setServiceState(OpenApiBOUtils.getServiceState());
        OpenApiBOUtils.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private static void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        OpenApiBOUtils.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private static ServiceStateManager.ServiceState getServiceState() {
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("ALL_SERVICE");
        return state;
    }

    private static void checkPluginService() throws CannotCreateServiceManagerException {
        if (!ServiceManagerFactory.getServiceManager().contains("PLUGIN_SERVICE_EP")) {
            ServerConfigServiceInitializer.initPluginService(null);
        }
    }

    public static BizController getBusinessController(Context ctx, BOSObjectType bosType) throws BOSException {
        return EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)bosType);
    }

    public static final Class<?> getBizObjectValueClass(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        String clzObjectValueName = entityObjectInfo.getObjectValueClass();
        Class<?> clzObjectValue = null;
        try {
            clzObjectValue = Class.forName(clzObjectValueName);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("can't find " + clzObjectValueName);
        }
        return clzObjectValue;
    }
}

