/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.DataTypes;

public class ChildrenIteration
extends Feature {
    public static final String NAME = "children-iterator";
    private VariableImpl<?> masterVar;
    private VariableImpl<?> shadowVar;
    private VariableImpl<?> tempVar;
    private String varName;

    public ChildrenIteration(String var) {
        this.varName = var;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"children-start", "data-area-creation"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    @Override
    public void postHandle(NodeImpl node) {
        if (node.getChildrenCount() == 0) {
            return;
        }
        if (this.masterVar != null) {
            return;
        }
        this.masterVar = node.retrieveVariable(this.varName);
        if (!this.masterVar.getType().acceptMultiValue()) {
            throw new RuntimeException("\u53d8\u91cf(" + this.varName + ")\u662f\u539f\u5b50\u7c7b\u578b\uff01");
        }
        DataType elementType = this.masterVar.getType().getElementType();
        GroupImpl scope = new GroupImpl(node.getFlow(), "ig-" + node.getId(), "for-each:" + node);
        this.shadowVar = scope.addVariable("isv-" + node.getId(), this.masterVar.getTitle(), this.masterVar.getName(), elementType, null, false);
        this.tempVar = this.shadowVar.addVariable("iav-" + node.getId(), this.masterVar.getTitle(), this.masterVar.getName(), DataTypes.QUEUE(elementType), null, false);
        for (NodeImpl child : node.getChildren()) {
            child.join(scope, 0);
        }
        node.insert(NIS.CHILDREN_ITERATION_INIT);
        node.insert(NIS.CHILDREN_ITERATION_BEGIN);
        node.insert(NIS.CHILDREN_ITERATION_END);
    }

    public VariableImpl<?> getMasterVar() {
        return this.masterVar;
    }

    public VariableImpl<?> getShadowVar() {
        return this.shadowVar;
    }

    public VariableImpl<?> getTempVar() {
        return this.tempVar;
    }
}

