/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.m;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.VIS;
import com.kingdee.cbos.process.vm.internal.i.wrapper.VariableListenerWrapper;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.Priority;
import com.kingdee.cbos.process.vm.internal.m.VariableScopeImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Listener;
import java.util.Map;

public class VariableImpl<P extends VariableScopeImpl<?>>
extends VariableScopeImpl<VariableImpl<P>>
implements Variable<P> {
    private String name;
    private P parent;
    private DataType type;
    private Object initValue;
    private int address;
    private boolean singleton;

    VariableImpl(FlowImpl flow, String id, String title, String name, DataType type, Object initValue, boolean singleton, P parent) {
        super(flow, id, title, Priority.QUEUE);
        this.name = name;
        this.type = type;
        this.initValue = initValue;
        this.parent = parent;
        this.address = flow.variableCount() - 1;
        this.singleton = singleton;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public Object getInitValue() {
        return this.initValue;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public void addListener(Listener<?> listener) {
        this.getFlow().registerListener(listener, this);
        Listener l = listener;
        ((VariableScopeImpl)this).addListener(new VariableListenerWrapper(l, this.getFlow()));
        this.insertDefault();
    }

    @Override
    public void insert(Instruction<VariableImpl<P>> i) {
        super.insert(i);
        this.insertDefault();
    }

    private void insertDefault() {
        super.insert(VIS.END);
        super.insert(VIS.THROW_ERROR);
        super.insert(VIS.HALT_ON_FAILED);
        super.insert(VIS.RESUME_FROM_FAILED);
        super.insert(VIS.GOTO_DISPOSING_ON_TERMINATED);
        super.insert(VIS.HALT_ON_SUSPENED);
        super.insert(VIS.RESUME_FROM_SUSPENDED);
    }

    @Override
    Map<String, VariableImpl<? extends VariableScope>> getOtherAvailableVariables() {
        return ((VariableScopeImpl)this.getParent()).getAvailableVariables();
    }

    @Override
    void dumpMicroProgram(StringBuilder sb) {
        sb.append("\r\n    ").append(this.getId() + "(" + this.getName() + ")");
        if (!this.getFlow().equals(this.getParent())) {
            sb.append("@").append(this.getParent());
        }
        sb.append(": ");
        super.dumpMicroProgram(sb);
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }
}

