/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r;

import com.kingdee.cbos.process.vm.internal.i.common.Halt;
import com.kingdee.cbos.process.vm.internal.m.AbstractElement;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableScopeImpl;
import com.kingdee.cbos.process.vm.internal.r.ControllerImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.EnactmentServiceImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.PropertyContainerImpl;
import com.kingdee.cbos.process.vm.internal.r.mode.ModeImpl;
import com.kingdee.cbos.process.vm.internal.t.a.Error_;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.runtime.EnactmentService;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.runtime.Profile;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FlowContextImpl
extends PropertyContainerImpl
implements FlowContext {
    private FlowImpl flow;
    private int counter = 0;
    private boolean running = false;
    private boolean started = false;
    private boolean closed = false;
    private HashMap<String, ExecutionImpl<?>> executions = new HashMap();
    private LinkedList<ExecutionImpl<?>> executionQueue = new LinkedList();
    private LinkedList<ExecutionImpl<?>> executionStack = new LinkedList();
    private DataAreaImpl rootDataArea;
    private ExecutionImpl<NodeImpl> rootExecution;
    private ExecutionImpl<?> lastExecution;
    private Profile profile = Profile.NONE;
    private Exception error;
    private static final String BREAK_POINTS = "BREAK_POINTS";

    private FlowContextImpl() {
    }

    public static FlowContextImpl fromXml(FlowImpl flow, Document document) {
        HashMap<String, FlowImpl> flows = new HashMap<String, FlowImpl>();
        flows.put(flow.getId(), flow);
        FlowContextImpl ctx = new FlowContextImpl();
        Element root = document.getDocumentElement();
        ctx.flow = flow;
        ctx.counter = Integer.parseInt(root.getAttribute("counter"));
        ctx.running = Boolean.valueOf(root.getAttribute("running"));
        ctx.started = Boolean.valueOf(root.getAttribute("started"));
        ctx.closed = Boolean.valueOf(root.getAttribute("closed"));
        ctx.profile = Profile.valueOf(root.getAttribute("profile"));
        ctx.error = (Exception)Error_.toError(root.getAttribute("error"));
        ctx.restoreProperties(root);
        FlowContextImpl.restoreRootDataArea(flows, ctx, root);
        FlowContextImpl.restoreLastExecution(ctx, root);
        FlowContextImpl.restoreExecutionStack(ctx, root);
        FlowContextImpl.restoreExecutionQueue(ctx, root);
        return ctx;
    }

    private static void restoreExecutionQueue(FlowContextImpl ctx, Element root) {
        String ids = root.getAttribute("execution-queue");
        if (ids != null && ids.length() > 0) {
            for (String id : ids.split(",")) {
                ctx.executionQueue.add((ExecutionImpl<?>)ctx.getExecution(id));
            }
        }
    }

    private static void restoreExecutionStack(FlowContextImpl ctx, Element root) {
        String ids = root.getAttribute("execution-stack");
        if (ids != null && ids.length() > 0) {
            for (String id : ids.split(",")) {
                Execution e = ctx.getExecution(id);
                if (e == null) continue;
                ctx.executionStack.add((ExecutionImpl<?>)e);
            }
        }
    }

    private static void restoreLastExecution(FlowContextImpl ctx, Element root) {
        String id = root.getAttribute("last-execution");
        ctx.lastExecution = ctx.getExecution(id);
    }

    private static void restoreRootDataArea(HashMap<String, FlowImpl> flows, FlowContextImpl ctx, Element root) {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            if (!(nodes.item(i) instanceof Element) || !(e = (Element)nodes.item(i)).getNodeName().equals("data-area")) continue;
            ctx.rootDataArea = DataAreaImpl.fromXml(flows, ctx, e, null);
            break;
        }
        if (ctx.rootDataArea == null) {
            throw new RuntimeException("\u6839\u6570\u636e\u533a\u4e0d\u5b58\u5728\uff01");
        }
        if (ctx.rootExecution == null) {
            throw new RuntimeException("\u6839\u6267\u884c\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
    }

    @Override
    public Document toXml() {
        Document doc = XmlUtil.parse("<context />");
        Element root = doc.getDocumentElement();
        root.setAttribute("counter", String.valueOf(this.counter));
        root.setAttribute("running", String.valueOf(this.running));
        root.setAttribute("started", String.valueOf(this.started));
        root.setAttribute("closed", String.valueOf(this.closed));
        root.setAttribute("profile", this.profile.name());
        root.setAttribute("error", Error_.toString(this.error));
        this.saveDataAreas(doc, root);
        this.saveProperties(root);
        this.saveLastExecution(root);
        this.saveExecutionQueue(root);
        this.saveExecutionStack(root);
        return doc;
    }

    private void saveDataAreas(Document doc, Element root) {
        Element dataArea = doc.createElement("data-area");
        root.appendChild(dataArea);
        this.rootDataArea.toXml(dataArea);
    }

    private void saveLastExecution(Element root) {
        if (this.lastExecution != null) {
            root.setAttribute("last-execution", this.lastExecution.getId());
        }
    }

    private void saveExecutionStack(Element root) {
        StringBuilder sb = new StringBuilder();
        for (ExecutionImpl executionImpl : this.executionStack) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(executionImpl.getId());
        }
        root.setAttribute("execution-stack", sb.toString());
    }

    private void saveExecutionQueue(Element root) {
        StringBuilder sb = new StringBuilder();
        for (ExecutionImpl executionImpl : this.executionQueue) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(executionImpl.getId());
        }
        root.setAttribute("execution-queue", sb.toString());
    }

    public FlowContextImpl(FlowImpl flow) {
        this.flow = flow;
        this.rootDataArea = new DataAreaImpl(this);
        new ExecutionImpl<NodeImpl>(null, flow.getRoot(), this.rootDataArea, null, null);
    }

    public void assignInput(Object ... input) {
        List<VariableImpl<FlowImpl>> variables = this.flow.getInputVariables();
        if (variables.size() != input.length) {
            throw new RuntimeException("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!");
        }
        for (int i = 0; i < input.length; ++i) {
            VariableImpl<FlowImpl> v = variables.get(i);
            this.rootDataArea.clear(v);
            this.rootDataArea.innerSetAt(v, input[i]);
        }
    }

    public void setStopped(boolean stoppedOnly) {
        if (!stoppedOnly && this.isRunning()) {
            this.executionQueue.addFirst(this.lastExecution);
        }
        this.running = false;
    }

    public void push(ExecutionImpl<?> e) {
        switch (((VariableScopeImpl)e.getDefine()).getPriority()) {
            case STACK: {
                this.executionStack.addLast(e);
                break;
            }
            case QUEUE: {
                this.executionQueue.addLast(e);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u53ef\u80fd\u6267\u884c\u5230\u8fd9\u4e00\u884c\uff01");
            }
        }
    }

    public void enqueue(ExecutionImpl<?> e) {
        this.executionQueue.addLast(e);
    }

    public void enqueueFirst(ExecutionImpl<?> e) {
        this.executionQueue.addFirst(e);
    }

    public DataAreaImpl getRootDataArea() {
        return this.rootDataArea;
    }

    public ExecutionImpl<NodeImpl> getRootExecution() {
        return this.rootExecution;
    }

    ExecutionImpl<?> pop() {
        ExecutionImpl<?> e;
        if (this.executionQueue.size() > 0) {
            this.lastExecution = this.executionQueue.removeFirst();
            e = this.lastExecution;
        } else if (this.executionStack.size() > 0) {
            this.lastExecution = this.executionStack.removeLast();
            e = this.lastExecution;
        } else {
            e = null;
        }
        return e;
    }

    public int stackSize() {
        return this.executionStack.size();
    }

    public ExecutionImpl<?> getLastExecution() {
        return this.lastExecution;
    }

    public int nextId() {
        return this.counter++;
    }

    @Override
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    void register(ExecutionImpl<?> e) {
        this.checkAndSetRootExecution(e);
        this.executions.put(e.getId(), e);
    }

    private void checkAndSetRootExecution(ExecutionImpl<?> e) {
        if (e.getParent() == null) {
            if (this.rootExecution != null) {
                throw new RuntimeException("\u6839\u6267\u884c\u5bf9\u8c61\u5df2\u5b58\u5728\uff01");
            }
            this.rootExecution = e;
        }
    }

    void unregister(ExecutionImpl<?> e) {
        this.executions.remove(e.getId());
    }

    public ExecutionImpl<?> getExecution(String id) {
        return this.executions.get(id);
    }

    public ExecutionImpl<NodeImpl> getNodeExecution(String id) {
        ExecutionImpl<NodeImpl> e = this.executions.get(id);
        if (e == null) {
            throw new RuntimeException("\u6267\u884c\u5bf9\u8c61{" + id + "}\u4e0d\u5b58\u5728\uff01");
        }
        VariableScope def = e.getDefine();
        if (def instanceof NodeImpl) {
            return e;
        }
        throw new RuntimeException("{" + e + "}\u4e0d\u662f\u8282\u70b9\u6267\u884c\u5bf9\u8c61\uff01");
    }

    public List<ExecutionImpl<?>> getExecutions(String defId) {
        ArrayList list = new ArrayList();
        for (ExecutionImpl<?> e : this.executions.values()) {
            if (!((AbstractElement)((Object)e.getDefine())).getId().equals(defId)) continue;
            list.add(e);
        }
        return list;
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    @Override
    public FlowImpl getFlow() {
        return this.flow;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed() {
        this.closed = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void execute(Object ... args) throws Exception {
        if (this.isInterrupted() || this.isRunning()) {
            throw new RuntimeException("\u6d41\u7a0b\u5f53\u524d\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6216\u4e0a\u6b21\u6267\u884c\u88ab\u4e2d\u6b62\uff0c\u7981\u6b62\u8c03\u7528\u672c\u65b9\u6cd5\u3002");
        }
        ModeImpl.getModeImpl(this.flow).start(this, args);
    }

    public void setStarted() throws Exception {
        if (this.started) {
            throw new Exception("\u5df2\u542f\u52a8\u3002");
        }
        this.started = true;
        this.running = true;
    }

    public boolean setRunning() {
        if (this.running) {
            return false;
        }
        this.running = true;
        this.closed = false;
        this.started = true;
        return true;
    }

    @Override
    public void signal(String executionId) throws Exception {
        if (this.isClosed()) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u5524\u9192\uff01");
        }
        Execution e = this.getExecution(executionId);
        ((ExecutionImpl)e).signal();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public void terminate() throws Exception {
        if (this.isClosed()) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u7ec8\u6b62\uff01");
        }
        this.rootExecution.terminate();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public void suspend() throws Exception {
        if (this.isClosed()) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u6302\u8d77\uff01");
        }
        this.rootExecution.suspend();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.isClosed()) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u5524\u9192\uff01");
        }
        if (this.rootExecution.current() instanceof Halt) {
            this.rootExecution.resume();
        }
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }

    @Override
    public List<?> getOutput() {
        if (!this.closed) {
            return null;
        }
        List<VariableImpl<FlowImpl>> variables = this.flow.getOutputVariables();
        ArrayList<Object> output = new ArrayList<Object>(variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            output.add(this.rootDataArea.getAt(variables.get(i)));
        }
        return output;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public EnactmentService getService() {
        return new EnactmentServiceImpl(this);
    }

    @Override
    public void addInterrupt(String nodeId, Event<Node> e) {
        HashSet<String> breakPoints = (HashSet<String>)this.getProperty(nodeId + "_" + BREAK_POINTS);
        if (breakPoints == null) {
            breakPoints = new HashSet<String>();
            this.setProperty(nodeId + "_" + BREAK_POINTS, breakPoints);
        }
        int i = this.flow.getNode(nodeId).seekInstruction(e.getBaseAddress());
        breakPoints.add(String.valueOf(i));
    }

    public boolean existsInterrupt(VariableScopeImpl<?> scope, int index) {
        HashSet breakPoints = (HashSet)this.getProperty(scope.getId() + "_" + BREAK_POINTS);
        if (breakPoints != null) {
            return breakPoints.contains(String.valueOf(index));
        }
        return false;
    }

    @Override
    public void removeInterrupt(String nodeId, Event<Node> e) {
        HashSet breakPoints = (HashSet)this.getProperty(nodeId + "_" + BREAK_POINTS);
        if (breakPoints != null) {
            int i = this.flow.getNode(nodeId).seekInstruction(e.getBaseAddress());
            breakPoints.remove(String.valueOf(i));
            if (breakPoints.size() == 0) {
                this.setProperty(nodeId + "_" + BREAK_POINTS, (String)null);
            }
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.executionQueue.size() + this.executionStack.size() > 0;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public void resume(String executionId) throws Exception {
        if (this.isClosed()) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u5173\u95ed\uff0c\u7981\u6b62\u5524\u9192\uff01");
        }
        Execution e = this.getExecution(executionId);
        e.resume();
        if (this.setRunning()) {
            ControllerImpl.execute(this);
        }
    }
}

