/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.t.a;

import com.kingdee.cbos.process.vm.model.AtomicDataType;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Message;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.lang.reflect.Array;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageSchema
extends AtomicDataType {
    private boolean isTransient;
    private DataType[] fields;
    private int priorityField;

    public MessageSchema(DataType[] fields, int priorityField, boolean persistent) {
        this.isTransient = !persistent;
        this.fields = fields;
        this.priorityField = priorityField;
        if (priorityField >= 0) {
            if (priorityField >= fields.length) {
                throw new RuntimeException("\u4f18\u5148\u7ea7\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
            }
            if (!fields[priorityField].getValueClass().isAssignableFrom(Comparable.class)) {
                throw new RuntimeException("\u4f18\u5148\u7ea7\u5b57\u6bb5\u503c\u7684\u7c7b\u578b(" + fields[priorityField] + ")\u4e0d\u652f\u6301Comparable\u63a5\u53e3\uff01");
            }
        }
    }

    public DataType[] getFields() {
        return (DataType[])this.fields.clone();
    }

    public DataType getField(int i) {
        return this.fields[i];
    }

    public int getPriorityField() {
        return this.priorityField;
    }

    public int fieldCount() {
        return this.fields.length;
    }

    @Override
    public String getName() {
        return "message";
    }

    @Override
    public Object narrow(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return new Message(this.fields, this.priorityField, (Object[])value);
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            Object[] list = new Object[c.size()];
            int i = 0;
            for (Object o : c) {
                list[i++] = o;
            }
            return new Message(this.fields, this.priorityField, list);
        }
        if (value.getClass().isArray()) {
            Object[] list = new Object[Array.getLength(value)];
            for (int i = 0; i < list.length; ++i) {
                list[i++] = Array.get(value, i);
            }
            return new Message(this.fields, this.priorityField, list);
        }
        if (this.fields.length == 1) {
            return new Message(this.fields, this.priorityField, new Object[]{value});
        }
        throw new IllegalArgumentException(value + "\u4e0e\u6d88\u606f\u5b57\u6bb5\u4e0d\u5339\u914d\u3002");
    }

    @Override
    public Class<?> getValueClass() {
        return Message.class;
    }

    @Override
    public void toXml(Element element, Object packed) {
        if (packed == null) {
            element.setAttribute("is-null", "true");
            return;
        }
        Message msg = (Message)packed;
        Document doc = element.getOwnerDocument();
        for (int i = 0; i < this.fields.length; ++i) {
            Element v = doc.createElement("v");
            element.appendChild(v);
            this.fields[i].toXml(v, msg.get(i));
        }
    }

    @Override
    public Object fromXml(Element element, FlowContext ctx) {
        if ("true".equals(element.getAttribute("is-null"))) {
            return null;
        }
        int j = 0;
        NodeList list = element.getChildNodes();
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("v")) continue;
            values[j] = this.fields[j].fromXml((Element)node, ctx);
            ++j;
        }
        if (j == this.fields.length) {
            return new Message(this.fields, this.priorityField, values);
        }
        throw new RuntimeException("\u63d0\u4f9b\u7684\u503c\u4e0e\u6d88\u606f\u5b57\u6bb5\u4e0d\u5339\u914d\u3002");
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object wrap(Object innerValue) {
        return innerValue;
    }
}

