/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Serialization {
    private Serialization() {
    }

    public static <T> T dup(T o) {
        byte[] bytes = Serialization.toBytes(o);
        return (T)Serialization.fromBytes(bytes);
    }

    public static String dump(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println(t.getMessage());
        t.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }

    public static Object fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff01", e);
        }
    }

    public static byte[] toBytes(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5931\u8d25\uff01", e);
        }
        return baos.toByteArray();
    }

    public static byte[] toCompressedBytes(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ZipOutputStream zip = new ZipOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(zip);
            oos.writeObject(o);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5931\u8d25!", e);
        }
        return baos.toByteArray();
    }

    public static Object fromCompressedBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ZipInputStream zip = new ZipInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(zip);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25!", e);
        }
    }
}

