/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.app;

import com.kingdee.cbos.process.vm.utils.app.Hex;

public abstract class Encoding {
    public static final Encoding HEX = new Hex();

    public String encode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] encoded = this.encode(tmp);
        return Encoding.utf8ToString(encoded);
    }

    public static byte[] stringToUtf8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding.stringToUtf8() failed!", e);
        }
    }

    public static String utf8ToString(byte[] utf8) {
        try {
            return new String(utf8, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding.utf8ToString() failed!", e);
        }
    }

    public static StringBuilder xmlEncode(String s) {
        return Encoding.xmlEncode(s, new StringBuilder());
    }

    public static StringBuilder xmlEncode(String s, StringBuilder sb) {
        if (s == null) {
            return sb;
        }
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&#34;");
                    continue block7;
                }
                case '<': {
                    sb.append("&#60;");
                    continue block7;
                }
                case '>': {
                    sb.append("&#62;");
                    continue block7;
                }
                case '&': {
                    sb.append("&#38;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public String decode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] decoded = this.decode(tmp);
        return Encoding.utf8ToString(decoded);
    }

    public abstract byte[] encode(byte[] var1);

    public abstract byte[] decode(byte[] var1);

    public static boolean isQName(String s) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }
}

