/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.model;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectSegment {
    private String mainSQL;
    private Map<String, SelectSegment> mapBetweenMarkAndSubSelect;
    List<AbstractConditionSegment> conditionSegments;

    public String toSQL() {
        this.subSelectToSQL();
        this.conditionsToSQL();
        return this.mainSQL;
    }

    public void setRawSQL(String rawSQL) {
        this.mainSQL = rawSQL;
    }

    public void putMarkAndSubSelect(String mark, SelectSegment subSelectSegment) {
        if (this.mapBetweenMarkAndSubSelect == null) {
            this.mapBetweenMarkAndSubSelect = new HashMap<String, SelectSegment>();
        }
        this.mapBetweenMarkAndSubSelect.put(mark, subSelectSegment);
    }

    public boolean hasSubSelect() {
        return this.mapBetweenMarkAndSubSelect != null && !this.mapBetweenMarkAndSubSelect.isEmpty();
    }

    public List<SelectSegment> getSubSelect() {
        ArrayList<SelectSegment> subSelects = new ArrayList<SelectSegment>();
        if (this.hasSubSelect()) {
            subSelects.addAll(this.mapBetweenMarkAndSubSelect.values());
        }
        return subSelects;
    }

    public void removeConditionSegment(AbstractConditionSegment segment) {
        this.conditionSegments.remove(segment);
    }

    public void addConditionSegment(AbstractConditionSegment segment) {
        this.conditionSegments.add(segment);
    }

    public void addAllConditionSegment(List<AbstractConditionSegment> segments) {
        this.conditionSegments.addAll(segments);
    }

    public void setConditionSegments(List<AbstractConditionSegment> segments) {
        this.conditionSegments = segments;
    }

    public List<AbstractConditionSegment> getConditionSegments() {
        return this.conditionSegments;
    }

    private void subSelectToSQL() {
        if (this.mapBetweenMarkAndSubSelect == null) {
            return;
        }
        Set<Map.Entry<String, SelectSegment>> entrySet = this.mapBetweenMarkAndSubSelect.entrySet();
        for (Map.Entry<String, SelectSegment> entry : entrySet) {
            String mark = entry.getKey();
            SelectSegment subSelectSegment = this.mapBetweenMarkAndSubSelect.get(mark);
            this.mainSQL = this.mainSQL.replace(mark, subSelectSegment.toSQL());
        }
    }

    private void conditionsToSQL() {
        HashMap<String, ArrayList<AbstractConditionSegment>> mapBetweenSQLAndCondition = new HashMap<String, ArrayList<AbstractConditionSegment>>();
        for (AbstractConditionSegment segment : this.conditionSegments) {
            ArrayList<AbstractConditionSegment> segmentsInMap = (ArrayList<AbstractConditionSegment>)mapBetweenSQLAndCondition.get(segment.getRawSQL());
            if (segmentsInMap == null) {
                segmentsInMap = new ArrayList<AbstractConditionSegment>();
                segmentsInMap.add(segment);
                mapBetweenSQLAndCondition.put(segment.getRawSQL(), segmentsInMap);
                continue;
            }
            segmentsInMap.add(segment);
        }
        Set entrySet = mapBetweenSQLAndCondition.entrySet();
        for (Map.Entry entry : entrySet) {
            String rawSQL = (String)entry.getKey();
            List segments = (List)mapBetweenSQLAndCondition.get(rawSQL);
            int segmentSize = segments.size();
            if (segmentSize > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                for (int i = 0; i < segmentSize; ++i) {
                    AbstractConditionSegment conditionSegment = (AbstractConditionSegment)segments.get(i);
                    sb.append(conditionSegment.toSQL());
                    if (i == segmentSize - 1) {
                        sb.append(")");
                        continue;
                    }
                    if (conditionSegment.isOrConnective()) {
                        sb.append(" OR ");
                        continue;
                    }
                    sb.append(" AND ");
                }
                this.mainSQL = this.mainSQL.replace(rawSQL, sb.toString());
                continue;
            }
            this.mainSQL = this.mainSQL.replace(rawSQL, ((AbstractConditionSegment)segments.get(0)).toSQL());
        }
    }
}

