/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.model.condition;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InConditionSegment
extends AbstractConditionSegment {
    private static final String conditionRegex = "(.+?)( (?i)in\\s*\\(| (?i)in )(.+?)(\\)| ENDOFSQL)";
    private static Pattern conditionPattern = Pattern.compile("(.+?)( (?i)in\\s*\\(| (?i)in )(.+?)(\\)| ENDOFSQL)");
    private List<Object> conditions;
    private String left;

    public static boolean isMatched(String sql) {
        Matcher matcher = conditionPattern.matcher(InConditionSegment.addEndMark(sql));
        return matcher.find();
    }

    public List<Object> getConditions() {
        return this.conditions;
    }

    public String getLeft() {
        return this.left;
    }

    @Override
    public String toSQL() {
        int inSize = SQLHelper.getMaxParamSize();
        StringBuilder sb = new StringBuilder();
        sb.append(this.left);
        sb.append(" in ");
        sb.append('(');
        int bufferCount = 1;
        int sizeLimit = inSize * bufferCount;
        int c = this.conditions.size();
        for (int i = 0; i < c; ++i) {
            if (i < sizeLimit) {
                sb.append(this.conditions.get(i));
                if (i >= c - 1 || i >= sizeLimit - 1) continue;
                sb.append(',');
                continue;
            }
            sizeLimit = inSize * ++bufferCount;
            sb.append(')');
            sb.append(" or ");
            sb.append(this.left);
            sb.append(" in ");
            sb.append('(');
            sb.append(this.conditions.get(i));
            if (i >= c - 1 || i >= sizeLimit - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected void protectedFromSQL(String sql) {
        Matcher matcher = conditionPattern.matcher(sql);
        while (matcher.find()) {
            this.left = matcher.group(1);
            String conditionString = matcher.group(3);
            String[] conditionArray = conditionString.split(",");
            this.conditions = new ArrayList<Object>(conditionArray.length);
            int c = conditionArray.length;
            for (int i = 0; i < c; ++i) {
                this.conditions.add(conditionArray[i]);
            }
        }
    }

    @Override
    public boolean isExpected() {
        if (this.left == null) {
            return false;
        }
        for (Object condition : this.conditions) {
            if (!condition.toString().trim().contains(" ")) continue;
            return false;
        }
        return true;
    }
}

