/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.parser;

import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.AbstractConditionSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.model.condition.ConditionSegmentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractConditionParser {
    private List<String> bodys;
    private List<String> bodyPieces = new ArrayList<String>();
    private static final String bodySplitRegex = "( (?i)and | (?i)or )";
    private static Pattern splitPattern = Pattern.compile("( (?i)and | (?i)or )");
    List<AbstractConditionSegment> conditionSegments = new ArrayList<AbstractConditionSegment>();

    protected abstract List<String> getBody(String var1);

    public void parse(String sql) {
        this.bodys = this.getBody(sql);
        for (String body : this.bodys) {
            this.parseBody(body);
        }
        this.parseCondition();
    }

    public List<AbstractConditionSegment> getConditionSegments() {
        return this.conditionSegments;
    }

    private void parseBody(String body) {
        Matcher matcher = splitPattern.matcher(body);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, "|");
            result = matcher.find();
        }
        matcher.appendTail(sb);
        for (String bodyPiece : sb.toString().split("[|]")) {
            bodyPiece = bodyPiece.trim();
            bodyPiece = this.handleBracket(bodyPiece);
            this.bodyPieces.add(bodyPiece);
        }
        this.handleBetween();
    }

    private void parseCondition() {
        for (String bodyPiece : this.bodyPieces) {
            AbstractConditionSegment conditionSegment = ConditionSegmentFactory.createConditionSegment(bodyPiece);
            if (conditionSegment == null || !conditionSegment.isExpected()) continue;
            this.conditionSegments.add(conditionSegment);
        }
    }

    private void handleBetween() {
        boolean betweenExists = false;
        int iBetweenPiecesIdx = 0;
        int bodySize = this.bodyPieces.size();
        for (int i = 0; i < bodySize; ++i) {
            String bodyPiece = this.bodyPieces.get(i);
            if (bodyPiece.indexOf(" between ") < 0) continue;
            betweenExists = true;
            iBetweenPiecesIdx = i;
            break;
        }
        if (!betweenExists) {
            return;
        }
        ArrayList<String> newbodyPieces = new ArrayList<String>();
        for (int i = 0; i < bodySize; ++i) {
            String bodyPiece = this.bodyPieces.get(i);
            if (i >= iBetweenPiecesIdx && bodyPiece.indexOf(" between ") >= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(bodyPiece);
                sb.append(" and ");
                sb.append(this.bodyPieces.get(i + 1));
                newbodyPieces.add(sb.toString());
                ++i;
                continue;
            }
            newbodyPieces.add(bodyPiece);
        }
        this.bodyPieces = newbodyPieces;
    }

    private String handleBracket(String bodyPiece) {
        if (bodyPiece.startsWith("(") && bodyPiece.endsWith(")")) {
            bodyPiece = bodyPiece.substring(1);
            bodyPiece = bodyPiece.substring(0, bodyPiece.length() - 1);
        }
        return bodyPiece;
    }
}

