/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.macro.sql.parser;

import com.kingdee.bos.qing.data.domain.macro.sql.model.SelectSegment;
import com.kingdee.bos.qing.data.domain.macro.sql.parser.HavingConditionParser;
import com.kingdee.bos.qing.data.domain.macro.sql.parser.SubSelectParser;
import com.kingdee.bos.qing.data.domain.macro.sql.parser.WhereConditionParser;

public class SelectSegmentParser {
    public static SelectSegment parse(String sql) {
        SelectSegment selectSegment = new SelectSegment();
        sql = SelectSegmentParser.handleSubSelect(sql, selectSegment);
        SelectSegmentParser.parseWhere(sql, selectSegment);
        SelectSegmentParser.parseHaving(sql, selectSegment);
        selectSegment.setRawSQL(sql);
        return selectSegment;
    }

    private static void parseWhere(String sql, SelectSegment selectSegment) {
        WhereConditionParser whereParser = new WhereConditionParser();
        whereParser.parse(sql);
        selectSegment.setConditionSegments(whereParser.getConditionSegments());
    }

    private static void parseHaving(String sql, SelectSegment selectSegment) {
        HavingConditionParser havingParser = new HavingConditionParser();
        havingParser.parse(sql);
        selectSegment.addAllConditionSegment(havingParser.getConditionSegments());
    }

    private static String handleSubSelect(String sql, SelectSegment selectSegment) {
        sql = SubSelectParser.parse(sql, selectSegment);
        return sql;
    }
}

