/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl;

import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DefaultResultSetDataConvertor
implements IResultSetDataConvertor {
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();

    protected Object getNumber(ResultSet rs, int columnIndex) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = rs.getBigDecimal(columnIndex);
            if (bigDecimal != null && bigDecimal.scale() > 15) {
                bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bigDecimal;
    }

    @Override
    public Object getData(ResultSet rs, String associateName, DataType inputdataType) throws SQLException {
        int columnIndex = 0;
        if (!this.columnIndexMap.containsKey(associateName)) {
            columnIndex = rs.findColumn(associateName);
            this.columnIndexMap.put(associateName, columnIndex);
        } else {
            columnIndex = this.columnIndexMap.get(associateName);
        }
        Object priColumnValue = null;
        switch (inputdataType) {
            case BOOLEAN: {
                priColumnValue = rs.getBoolean(columnIndex);
                break;
            }
            case INT: 
            case NUMBER: {
                priColumnValue = this.getNumber(rs, columnIndex);
                break;
            }
            case DATE: {
                priColumnValue = rs.getDate(columnIndex);
                break;
            }
            case DATETIME: {
                priColumnValue = rs.getTimestamp(columnIndex);
                break;
            }
            default: {
                priColumnValue = rs.getString(columnIndex);
            }
        }
        return priColumnValue;
    }
}

