/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl;

import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.DefaultResultSetDataConvertor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class OdpsResultSetDataConvertor
extends DefaultResultSetDataConvertor {
    private static final Map<Integer, OdpsTypeConverter> converterMap = new HashMap<Integer, OdpsTypeConverter>();

    @Override
    protected Object getNumber(ResultSet rs, int columnIndex) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int type = meta.getColumnType(columnIndex);
        OdpsTypeConverter typeConverter = converterMap.get(type);
        if (null != typeConverter) {
            return typeConverter.getResult(rs, columnIndex);
        }
        return rs.getObject(columnIndex);
    }

    static {
        converterMap.put(3, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                BigDecimal bigDecimal = rs.getBigDecimal(columnIndex);
                if (bigDecimal != null && bigDecimal.scale() > 15) {
                    bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                }
                return bigDecimal;
            }
        });
        converterMap.put(-5, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                Long value = rs.getLong(columnIndex);
                return BigDecimal.valueOf(value);
            }
        });
        converterMap.put(4, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                int value = rs.getInt(columnIndex);
                return BigDecimal.valueOf(value);
            }
        });
        converterMap.put(5, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                int value = rs.getInt(columnIndex);
                return BigDecimal.valueOf(value);
            }
        });
        converterMap.put(-6, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                int value = rs.getInt(columnIndex);
                return BigDecimal.valueOf(value);
            }
        });
        converterMap.put(8, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                double value = rs.getDouble(columnIndex);
                BigDecimal bigDecimal = BigDecimal.valueOf(value);
                if (bigDecimal.scale() > 15) {
                    bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                }
                return bigDecimal;
            }
        });
        converterMap.put(6, new OdpsTypeConverter(){

            @Override
            public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
                float value = rs.getFloat(columnIndex);
                BigDecimal bigDecimal = BigDecimal.valueOf(value);
                if (bigDecimal.scale() > 15) {
                    bigDecimal = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                }
                return bigDecimal;
            }
        });
    }

    private static interface OdpsTypeConverter {
        public Object getResult(ResultSet var1, int var2) throws SQLException;
    }
}

