/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractPGSourceDomain
extends AbstractDBSourceJDBCAdapter {
    private static Set<String> ignoreSchemas = new HashSet<String>();

    @Override
    protected String getSPCmdFormate(DBSource dbSource) {
        return "{call \"" + dbSource.getSchema() + "\".\"%s\"( %s )}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setAutoCommit(true);
        String schemaName = StringUtils.isBlank((CharSequence)dataBase.getSchema()) ? "public" : dataBase.getSchema();
        String sql = String.format("SET search_path TO %s", schemaName);
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        finally {
            CloseUtil.close((Statement)ps);
        }
        connection.setAutoCommit(false);
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        StringBuilder sql = new StringBuilder("SELECT DISTINCT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA A WHERE A.CATALOG_NAME = ? AND A.SCHEMA_OWNER = ? AND SCHEMA_NAME = 'public'");
        sql.append(" UNION ALL");
        sql.append(" SELECT DISTINCT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA A WHERE A.CATALOG_NAME = ? AND A.SCHEMA_OWNER = ? AND SCHEMA_NAME != 'public'");
        List<String> databaseNameList = this.queryDBNames((DBSource)source, sql.toString(), new Object[]{dataBase.getDbName(), dataBase.getUserName(), dataBase.getDbName(), dataBase.getUserName()}, ignoreSchemas);
        if (!databaseNameList.contains("public")) {
            databaseNameList.add(0, "public");
        }
        return databaseNameList;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "select tablename from pg_tables where schemaname = ?";
        String viewSql = "select viewname from pg_views where schemaname = ?";
        String schemaName = StringUtils.isBlank((CharSequence)dataBase.getSchema()) ? "public" : dataBase.getSchema();
        this.queryTableLeafNodes(root, dataBase, tableSql, new Object[]{schemaName});
        this.queryTableLeafNodes(root, dataBase, viewSql, new Object[]{schemaName});
        return root;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT ROUTINE_NAME AS NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_CATALOG = ? AND ROUTINE_SCHEMA = ? ORDER BY ROUTINE_NAME";
        this.queryLeafNodes(root, dataBase, sql, new Object[]{dataBase.getDbName(), dataBase.getSchema()}, "storedProcedure");
        AbstractPGSourceDomain.checkStoredProcedureNameNotRepeat(root);
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        String sql = "SELECT P.PARAMETER_NAME,P.DATA_TYPE, P.PARAMETER_MODE FROM INFORMATION_SCHEMA.ROUTINES R JOIN INFORMATION_SCHEMA.PARAMETERS P ON R.SPECIFIC_NAME=P.SPECIFIC_NAME WHERE R.ROUTINE_NAME=? AND R.ROUTINE_SCHEMA=? ORDER BY R.ROUTINE_NAME, P.ORDINAL_POSITION";
        DBSource dataBase = (DBSource)source;
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName, dataBase.getSchema()});
    }

    static {
        ignoreSchemas.add("gp_toolkit");
        ignoreSchemas.add("pg_toast");
        ignoreSchemas.add("pg_bitmapindex");
        ignoreSchemas.add("pg_aoseg");
        ignoreSchemas.add("pg_catalog");
        ignoreSchemas.add("information_schema");
        ignoreSchemas.add("pg_temp_1");
        ignoreSchemas.add("pg_toast_temp_1");
    }
}

