/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Tables;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.StringUtils;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.JDBCConnectionPool;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.OdpsResultSetDataConvertor;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.OdpsTableAdapter;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AliyunOdpsSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String DRIVER = "com.aliyun.odps.jdbc.OdpsDriver";
    public static final String URL = "jdbc:odps:%s?project=%s";

    private AliyunOdpsSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new AliyunOdpsSourceJDBCAdapter();
    }

    @Override
    protected JDBCConnectionPool.JDBCModel checkerDataBaseParams(DBSource dataBase) throws AbstractDBConnectException {
        if (StringUtils.isNullOrEmpty((String)dataBase.getUserName()) || StringUtils.isNullOrEmpty((String)dataBase.getPassword())) {
            throw new DBConnectionOpenException("connection fail,reason:empty user name or password");
        }
        return super.checkerDataBaseParams(dataBase);
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        return String.format(URL, dataBase.getDbAddress(), dataBase.getDbName());
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        OdpsConnection odpsConn = connection.unwrap(OdpsConnection.class);
        RestClient rc = odpsConn.getOdps().getRestClient();
        String resouce = ResourceBuilder.buildProjectResource((String)dataBase.getDbName());
        int status = -1;
        String responseMsg = "";
        com.aliyun.odps.commons.transport.Connection transConn = null;
        try {
            transConn = rc.connect(resouce, "GET", null, new HashMap());
            Response response = transConn.getResponse();
            status = response.getStatus();
            responseMsg = response.getMessage();
        }
        catch (Exception e) {
            throw new SQLException("connect failed\uff0creason:" + e.getMessage(), e);
        }
        finally {
            try {
                if (transConn != null) {
                    transConn.disconnect();
                }
            }
            catch (IOException e) {
                LogUtil.error((String)"", (Throwable)e);
            }
        }
        if (status != 200) {
            throw new SQLException("connect failed\uff0creason: " + responseMsg);
        }
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBConnectException, DBExcuseException {
        DBSource dataBase = (DBSource)source;
        Connection conn = this.getConnection(dataBase);
        OdpsConnection odpsConnection = null;
        try {
            odpsConnection = conn.unwrap(OdpsConnection.class);
        }
        catch (SQLException e) {
            throw new DBConnectionOpenException(e);
        }
        finally {
            CloseUtil.close((Connection)conn);
        }
        return this.getTableNodeInfos(odpsConnection);
    }

    @Override
    protected IResultSetDataConvertor getDataConvertor() {
        return new OdpsResultSetDataConvertor();
    }

    private AbstractNode getTableNodeInfos(OdpsConnection conn) {
        FolderNode root = new FolderNode();
        Tables tables = conn.getOdps().tables();
        for (com.aliyun.odps.Table table : tables) {
            root.addChild(this.createTableLeafNode(table));
        }
        return root;
    }

    private LeafNode createTableLeafNode(com.aliyun.odps.Table table) {
        LeafNode leafNode = new LeafNode();
        leafNode.setName(table.getName());
        leafNode.setDisplayName(table.getName());
        leafNode.setType("table");
        return leafNode;
    }

    @Override
    public void setQueryTimeout(QingContext qingContext, PreparedStatement ps) throws SQLException {
    }

    @Override
    protected Table getTable(Connection conn, DBSource dbSource, String tableAssociateName) throws SQLException {
        com.aliyun.odps.Table table = this.getOdpsTable(tableAssociateName, conn.unwrap(OdpsConnection.class));
        OdpsTableAdapter odpsTableAdapter = new OdpsTableAdapter(table);
        Table qingTable = odpsTableAdapter.adapt();
        qingTable.setSource(dbSource.getName());
        return qingTable;
    }

    private com.aliyun.odps.Table getOdpsTable(String tableAssociateName, OdpsConnection conn) throws SQLException {
        com.aliyun.odps.Table table = this.selectTableByName(tableAssociateName, conn);
        if (null == table) {
            throw new SQLException("table not found in aliyun odps db");
        }
        this.reloadTableSchema(table);
        return table;
    }

    private com.aliyun.odps.Table selectTableByName(String tableAssociateName, OdpsConnection conn) {
        Tables tables = conn.getOdps().tables();
        Iterator iterator = tables.iterator();
        com.aliyun.odps.Table table = null;
        while (iterator.hasNext() && !(table = (com.aliyun.odps.Table)iterator.next()).getName().equalsIgnoreCase(tableAssociateName)) {
        }
        return table;
    }

    private void reloadTableSchema(com.aliyun.odps.Table table) throws SQLException {
        try {
            table.reload();
            if (table.getSchema() == null) {
                throw new SQLException("load table schema error,tableName:" + table.getName());
            }
        }
        catch (OdpsException e) {
            throw new SQLException("reload odps schema error,tableName:" + table.getName() + ".reason:" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected boolean needCalculateTotalCount() {
        return false;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("getDatabaseList not support.");
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }
}

