/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ApacheDrillSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE_DIRECT = "jdbc:drill:drillbit=%s:%s";
    public static final String DRIVER = "org.apache.drill.jdbc.Driver";
    public static final String URL_TEMPLATE_ZOOKEEPER = "jdbc:drill:zk=%s/drill/%s";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private ApacheDrillSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new ApacheDrillSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "";
    }

    @Override
    public String getRightDelimiter() {
        return "";
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA = '" + dataBase.getDbName() + "'";
        this.queryTableLeafNodes(root, dataBase, sql, null);
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA";
        return this.queryDBNames((DBSource)source, sql, null, ignoreDBs);
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String dbaddress = dataBase.getDbAddress();
        String dbport = dataBase.getDbPort();
        String dbName = dataBase.getDbName();
        String urlTemplate = "";
        ConnectTypeEnum connectTypeEnum = ConnectTypeEnum.fromPersistance(dataBase.getConnectType());
        urlTemplate = connectTypeEnum == ConnectTypeEnum.Direct ? URL_TEMPLATE_DIRECT : URL_TEMPLATE_ZOOKEEPER;
        return String.format(urlTemplate, dbaddress, dbport, dbName);
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public String wrapTableAssociateName(DBSource dbSource, String tableAssociateName) {
        return dbSource.getDbName() + "." + tableAssociateName;
    }

    static {
        ignoreDBs.add("sys");
        ignoreDBs.add("information_schema");
    }

    private static enum ConnectTypeEnum {
        Direct,
        ZooKeeper;


        public static ConnectTypeEnum fromPersistance(String name) {
            try {
                return ConnectTypeEnum.valueOf(name);
            }
            catch (Exception e) {
                throw new RuntimeException("Unknown ApacheDrillConnectType:" + name, e);
            }
        }
    }
}

