/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.AbstractPGSourceDomain;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;

public class GreenplumSourceJDBCAdapter
extends AbstractPGSourceDomain {
    public static final String URL_TEMPLATE = "jdbc:pivotal:greenplum://%s:%s;DatabaseName=%s";
    public static final String URL_CUSTOM_TEMPLATE = "jdbc:pivotal:greenplum://%s:%s;DatabaseName=%s;useUnicode=true;characterEncoding=%s;serverTimezone=%s;";
    public static final String DRIVER = "com.pivotal.jdbc.GreenplumDriver";

    private GreenplumSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new GreenplumSourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) throws AbstractDBConnectException {
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String customUrl = String.format(URL_CUSTOM_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), charset, timezone);
        if (otherSetting != null) {
            customUrl = customUrl + otherSetting;
        }
        return customUrl;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }
}

