/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class ImpalaSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String URL_TEMPLATE = "jdbc:impala://%s:%s/%s";
    private static final String DRIVER = "com.cloudera.impala.jdbc.Driver";

    private ImpalaSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new ImpalaSourceJDBCAdapter();
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        this.queryTableLeafNodes(root, dataBase, "show tables", null);
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        return this.queryDBNames((DBSource)source, "show databases", null, null);
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection conn) throws SQLException {
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public String getLeftDelimiter() {
        return "`";
    }

    @Override
    public String getRightDelimiter() {
        return "`";
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public void setQueryTimeout(QingContext qingContext, PreparedStatement ps) throws SQLException {
    }
}

