/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.util.ParameterDataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameterIoType;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MySQLSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&serverTimezone=Asia/Shanghai&zeroDateTimeBehavior=convertToNull&useCursorFetch=true&defaultFetchSize=100&disableMariaDbDriver";
    public static final String URL_TEMPLATE_MARIADB = "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf-8&serverTimezone=Asia/Shanghai&zeroDateTimeBehavior=convertToNull&useCursorFetch=true&defaultFetchSize=1000&useSSL=false";
    public static final String URL_CUSTOM_TEMPLATE = "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=%s&serverTimezone=%s";
    public static final String DRIVER = "com.mysql.jdbc.Driver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private MySQLSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new MySQLSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "`";
    }

    @Override
    public String getRightDelimiter() {
        return "`";
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        this.queryTableLeafNodes(root, dataBase, "show tables", null);
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "select SCHEMA_NAME from information_schema.SCHEMATA";
        return this.queryDBNames((DBSource)source, sql, null, ignoreDBs);
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            String url = SystemPropertyUtil.getString((String)"qing.jdbc.url.mysql", (String)URL_TEMPLATE_MARIADB);
            return String.format(url, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String customJDBCUrl = String.format(URL_CUSTOM_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), charset, timezone);
        if (otherSetting != null) {
            customJDBCUrl = customJDBCUrl + "&" + otherSetting;
        }
        return customJDBCUrl;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT DISTINCT NAME FROM mysql.proc WHERE DB= ? AND TYPE='PROCEDURE' ORDER BY NAME";
        this.queryLeafNodes(root, dataBase, sql, new Object[]{dataBase.getDbName()}, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        ArrayList<StoredProcedureParameter> arrayList;
        DBSource dataBase = (DBSource)source;
        Connection conn = this.getConnection(dataBase);
        ResultSet trs = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            String paramList;
            Blob b;
            String sql = "SELECT param_list FROM mysql.proc WHERE DB= ? AND NAME=? AND TYPE='PROCEDURE'";
            sql = this.checkAndAddKSqlDialect(sql);
            ps = conn.prepareStatement(sql);
            ps.setString(1, dataBase.getDbName());
            ps.setString(2, storedProcedureName);
            rs = ps.executeQuery();
            ArrayList<StoredProcedureParameter> parameters = new ArrayList<StoredProcedureParameter>();
            if (rs.next() && (b = rs.getBlob("PARAM_LIST")) != null && !"".equals(paramList = new String(b.getBytes(1L, (int)b.length())))) {
                String[] strs;
                for (String str : strs = paramList.split(",")) {
                    String dataType;
                    String name;
                    StoredProcedureParameter parameter = new StoredProcedureParameter();
                    String dbIoType = "IN";
                    String[] arr = (str = str.trim()).split("\\s+");
                    if (arr.length == 3) {
                        name = arr[1];
                        dataType = arr[2];
                        dbIoType = arr[0];
                    } else {
                        name = arr[0];
                        dataType = arr[1];
                    }
                    if (dataType != null && dataType.indexOf(40) > -1) {
                        int idx = dataType.indexOf(40);
                        dataType = dataType.substring(0, idx);
                    }
                    parameter.setName(name);
                    parameter.setDataType(ParameterDataTypeUtil.dbDataTypeToParameterDataType(dataType));
                    parameter.setIoType(StoredProcedureParameterIoType.dbTypeToStoredProcedureParameterIoType(dataBase.getDbType(), dbIoType));
                    parameters.add(parameter);
                }
            }
            arrayList = parameters;
        }
        catch (SQLException e) {
            try {
                throw new DBExcuseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(ps);
                CloseUtil.close(trs);
                CloseUtil.close(rs);
                CloseUtil.close((Connection)conn);
                throw throwable;
            }
        }
        CloseUtil.close((Statement)ps);
        CloseUtil.close(trs);
        CloseUtil.close((ResultSet)rs);
        CloseUtil.close((Connection)conn);
        return arrayList;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(false);
        connection.setAutoCommit(false);
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT VERSION() AS VERSION";
    }

    static {
        ignoreDBs.add("information_schema");
        ignoreDBs.add("performance_schema");
        ignoreDBs.add("mysql");
        ignoreDBs.add("sys");
        ignoreDBs.add("INFORMATION_SCHEMA");
        ignoreDBs.add("PERFORMANCE_SCHEMA");
    }
}

