/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.util.List;

public class OracleSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE_SID = "jdbc:oracle:thin:@%s:%s:%s";
    public static final String URL_CUSTOM_SID = "jdbc:oracle:thin:@%s:%s:%s?useUnicode=true&characterEncoding=%s&useTimezone=true&serverTimezone=%s";
    public static final String URL_TEMPLATE_ServerName = "jdbc:oracle:thin:@//%s:%s/%s";
    public static final String URL_CUSTOM_SERVERNAME = "jdbc:oracle:thin:@//%s:%s/%s?useUnicode=true&characterEncoding=%s&useTimezone=true&serverTimezone=%s";
    public static final String DRIVER = "oracle.jdbc.driver.OracleDriver";

    private OracleSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new OracleSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    @Override
    public String getSchemaPattern(DBSource dataBase) {
        return "%" + dataBase.getUserName().toUpperCase() + "%";
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "SELECT TABLE_NAME FROM USER_TABLES  ORDER BY TABLE_NAME";
        String viewSql = "SELECT VIEW_NAME FROM USER_VIEWS  ORDER BY VIEW_NAME";
        this.queryTableLeafNodes(root, dataBase, tableSql, null);
        this.queryTableLeafNodes(root, dataBase, viewSql, null);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String urlTemplate;
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            String urlTemplate2 = "Server Name".equals(dataBase.getConnectType()) ? URL_TEMPLATE_ServerName : URL_TEMPLATE_SID;
            return String.format(urlTemplate2, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String string = urlTemplate = "Server Name".equals(dataBase.getConnectType()) ? URL_CUSTOM_SERVERNAME : URL_CUSTOM_SID;
        if (otherSetting != null) {
            urlTemplate = urlTemplate + "&" + otherSetting;
        }
        return String.format(urlTemplate, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), charset, timezone);
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT DISTINCT NAME FROM USER_SOURCE WHERE TYPE = 'PROCEDURE' ORDER BY NAME";
        this.queryLeafNodes(root, dataBase, sql, null, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        String sql = "SELECT PARAMETER.ARGUMENT_NAME AS PARAMETERNAME,PARAMETER.DATA_TYPE AS PARAMETERTYPE,PARAMETER.IN_OUT AS PARAMETERISOUTPUT FROM USER_ARGUMENTS PARAMETER WHERE PARAMETER.OBJECT_NAME = ? ORDER BY PARAMETER.POSITION";
        DBSource dataBase = (DBSource)source;
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName});
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("getDatabaseList not support.");
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT BANNER AS VERSION FROM V$VERSION";
    }
}

