/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.AbstractPGSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;

public class PostgreSQLSourceJDBCAdapter
extends AbstractPGSourceDomain {
    public static final String URL_TEMPLATE = "jdbc:postgresql://%s:%s/%s?OpenSourceSubProtocolOverride=true";
    public static final String URL_CUSTOM_TEMPLATE = "jdbc:postgresql://%s:%s/%s?useUnicode=true&characterEncoding=%s&serverTimezone=%s&OpenSourceSubProtocolOverride=true";
    public static final String DRIVER = "org.postgresql.Driver";

    private PostgreSQLSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new PostgreSQLSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        String delimiter = System.getProperty("qing.pg.sqltable.delimiter");
        if (null == delimiter) {
            return "\"";
        }
        return delimiter;
    }

    @Override
    public String getRightDelimiter() {
        String delimiter = System.getProperty("qing.pg.sqltable.delimiter");
        if (null == delimiter) {
            return "\"";
        }
        return delimiter;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String customJDBCUrl = String.format(URL_CUSTOM_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), charset, timezone);
        if (otherSetting != null) {
            customJDBCUrl = customJDBCUrl + "&" + otherSetting;
        }
        return customJDBCUrl;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT VERSION() AS VERSION";
    }
}

