/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SQLServerSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:sqlserver://%s:%s;DatabaseName=%s;trustServerCertificate=true";
    public static final String URL_CUSTOM_TEMPLATE = "jdbc:sqlserver://%s:%s;DatabaseName=%s;useUnicode=true;characterEncoding=%s;serverTimezone=%s;";
    public static final String DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private SQLServerSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new SQLServerSourceJDBCAdapter();
    }

    @Override
    public String getLeftDelimiter() {
        return "\"";
    }

    @Override
    public String getRightDelimiter() {
        return "\"";
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT NAME FROM SYSOBJECTS WHERE TYPE = 'U' OR TYPE = 'V' ORDER BY NAME";
        this.queryTableLeafNodes(root, dataBase, sql, null);
        return root;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "USE MASTER; SELECT NAME FROM SYSDATABASES";
        return this.queryDBNames((DBSource)source, sql, null, ignoreDBs);
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        String dbaddress = dataBase.getDbAddress();
        String dbport = dataBase.getDbPort();
        String dbName = dataBase.getDbName();
        String charset = dataBase.getAdvanceSetting().getCharset();
        String timezone = dataBase.getAdvanceSetting().getTimezone();
        String otherSetting = dataBase.getAdvanceSetting().getOtherSetting();
        if (charset == null && timezone == null && otherSetting == null) {
            return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
        }
        String customUrl = String.format(URL_CUSTOM_TEMPLATE, dbaddress, dbport, dbName, charset, timezone);
        if (otherSetting != null) {
            customUrl = customUrl + otherSetting;
        }
        return customUrl;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT DISTINCT NAME FROM SYSOBJECTS WHERE TYPE = 'P' ORDER BY NAME";
        this.queryLeafNodes(root, dataBase, sql, null, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        String sql = "SELECT PARAMETER.NAME AS PARAMETERNAME,TYPES.NAME AS PARAMETERTYPE,PARAMETER.IS_OUTPUT AS PARAMETERISOUTPUT FROM SYS.PROCEDURES PROCEDURES LEFT JOIN SYS.PARAMETERS PARAMETER ON PROCEDURES.OBJECT_ID = PARAMETER.OBJECT_ID INNER JOIN SYS.TYPES TYPES ON PARAMETER.SYSTEM_TYPE_ID = TYPES.SYSTEM_TYPE_ID WHERE PROCEDURES.TYPE = 'P' AND TYPES.NAME != 'sysname' AND PARAMETER.NAME != 'RETURN_VALUE' AND PROCEDURES.NAME = ? ORDER BY PARAMETER.PARAMETER_ID";
        DBSource dataBase = (DBSource)source;
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName});
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT @@VERSION AS VERSION";
    }

    static {
        ignoreDBs.add("master");
        ignoreDBs.add("msdb");
        ignoreDBs.add("model");
        ignoreDBs.add("tempdb");
        ignoreDBs.add("Resource");
    }
}

