/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.exception.db.DBFileNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SqliteSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:sqlite:%s";
    public static final String DRIVER = "org.sqlite.JDBC";

    private SqliteSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new SqliteSourceJDBCAdapter();
    }

    public boolean canEntityChangeOnline() {
        return false;
    }

    @Override
    public String getLeftDelimiter() {
        return "";
    }

    @Override
    public String getRightDelimiter() {
        return "";
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(false);
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "SELECT name FROM sqlite_master WHERE type='table' or type ='view';";
        this.queryTableLeafNodes(root, dataBase, sql, null);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) throws AbstractDBConnectException {
        IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)dataBase.getDbAddress());
        if (!qingFile.exists()) {
            qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)dataBase.getDbAddress());
        }
        String fullPath = null;
        try {
            fullPath = qingFile.getLocalFullPath();
        }
        catch (FileNotFoundException e) {
            throw new DBFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new DBConnectionOpenException((Throwable)e, "load Access File failed.");
        }
        return String.format(URL_TEMPLATE, fullPath);
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("getDatabaseList not support.");
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        throw new UnsupportedOperationException("This type of db does not support stored procedure");
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT SQLITE_VERSION() AS VERSION";
    }
}

