/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class SysbaseIQSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String DRIVER_CLASS = "com.sybase.jdbc3.jdbc.SybDriver";
    private static final String JDBC_URL = "jdbc:sybase:Tds:%s:%s";

    private SysbaseIQSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new SysbaseIQSourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        return String.format(JDBC_URL, dataBase.getDbAddress(), dataBase.getDbPort());
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection conn) throws SQLException {
        String dbName = StringUtils.isEmpty((CharSequence)dataBase.getDbName()) ? "master" : dataBase.getDbName();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("use " + dbName);
            ps.execute();
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps);
            throw throwable;
        }
        CloseUtil.close((Statement)ps);
        conn.setReadOnly(true);
        conn.setAutoCommit(true);
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "SELECT A.ALIAS FROM SA_DB_INFO() A";
        return this.queryDBNames((DBSource)source, sql, null, null);
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = " select name from sysobjects where type='U' and uid not in ('6','3')";
        this.queryTableLeafNodes(root, dataBase, sql, null);
        return root;
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = " SELECT proc_name AS NAME FROM sp_iqprocedure() WHERE proc_owner NOT IN ( 'GROUPO','rs_systabgroup') ORDER BY proc_name ASC";
        this.queryLeafNodes(root, dataBase, sql, null, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        String sql = "select A.parm_name as paramname,a.domain_name as paramtype,a.parm_mode as parammode from sp_iqprocparm() A WHERE proc_name =? and parm_type ='normal'";
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName});
    }

    protected String getSPCmdFormate() {
        return "execute %s %s";
    }
}

