/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SysbaseSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String DRIVER_CLASS = "com.sybase.jdbc3.jdbc.SybDriver";
    private static final String JDBC_URL = "jdbc:sybase:Tds:%s:%s";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private SysbaseSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new SysbaseSourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        return String.format(JDBC_URL, dataBase.getDbAddress(), dataBase.getDbPort());
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = " select name from sysobjects where type='U'";
        this.queryTableLeafNodes(root, dataBase, sql, null);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection conn) throws SQLException {
        String dbName = StringUtils.isEmpty((CharSequence)dataBase.getDbName()) ? "master" : dataBase.getDbName();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("use " + dbName);
            ps.execute();
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps);
            throw throwable;
        }
        CloseUtil.close((Statement)ps);
        conn.setReadOnly(true);
        conn.setAutoCommit(true);
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "select name from sysdatabases";
        return this.queryDBNames((DBSource)source, sql, null, ignoreDBs);
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = " select name from sysobjects where type='P'";
        this.queryLeafNodes(root, dataBase, sql, null, "storedProcedure");
        return root;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractDBSourceException {
        DBSource dataBase = (DBSource)source;
        String sql = "select sc.name as paramname,st.name as paramtype ,sc.status2 as parammode from syscolumns sc,sysobjects so,systypes st where so.name=? and  so.type='P' and so.id=sc.id and sc.usertype=st.usertype";
        return this.queryStoredProcedureParams(sql, dataBase, new Object[]{storedProcedureName});
    }

    protected String getSPCmdFormate() {
        return "execute %s %s";
    }

    static {
        ignoreDBs.add("master");
        ignoreDBs.add("model");
        ignoreDBs.add("tempdb");
        ignoreDBs.add("sybsystemdb");
        ignoreDBs.add("sybsystemprocs");
        ignoreDBs.add("sybmgmtdb");
    }
}

