/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TDSQLSourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    private static final String URL_TEMPLATE = "jdbc:tdsql-mysql://%s:%s/%s";
    private static final String DRIVER = "com.tencentcloud.tdsql.mysql.cj.jdbc.Driver";
    private static Set<String> ignoreDBs = new HashSet<String>();

    private TDSQLSourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new TDSQLSourceJDBCAdapter();
    }

    @Override
    protected String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName());
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractDBSourceException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String tableSql = "show tables";
        this.queryTableLeafNodes(root, dataBase, tableSql, null);
        return root;
    }

    @Override
    public String getLeftDelimiter() {
        return "`";
    }

    @Override
    public String getRightDelimiter() {
        return "`";
    }

    @Override
    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        String sql = "show databases";
        return this.queryDBNames((DBSource)source, sql, null, ignoreDBs);
    }

    @Override
    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) {
        return null;
    }

    @Override
    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) {
        return null;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(false);
        connection.setAutoCommit(false);
    }

    @Override
    public String getSelectVersionSql() {
        return "SELECT VERSION() AS VERSION";
    }

    static {
        ignoreDBs.add("information_schema");
        ignoreDBs.add("performance_schema");
        ignoreDBs.add("mysql");
        ignoreDBs.add("sys");
        ignoreDBs.add("INFORMATION_SCHEMA");
        ignoreDBs.add("PERFORMANCE_SCHEMA");
    }
}

