/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.query;

import com.kingdee.bos.qing.util.CloseUtil;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public abstract class AbstractQueryRunner {
    private volatile boolean pmdKnownBroken = false;

    public AbstractQueryRunner(boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, int returnedKeys) throws SQLException {
        return conn.prepareStatement(sql, returnedKeys);
    }

    protected abstract Connection prepareConnection() throws SQLException;

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        int sqlType;
        int i;
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            pmd = stmt.getParameterMetaData();
            i = pmd.getParameterCount();
            int n = sqlType = params == null ? 0 : params.length;
            if (i != sqlType) {
                throw new SQLException("Wrong number of parameters: expected " + i + ", was given " + sqlType);
            }
        }
        if (params != null) {
            for (i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    stmt.setObject(i + 1, params[i]);
                    continue;
                }
                sqlType = 12;
                if (!this.pmdKnownBroken) {
                    try {
                        if (pmd != null) {
                            sqlType = pmd.getParameterType(i + 1);
                        }
                    }
                    catch (SQLException var7) {
                        this.pmdKnownBroken = true;
                    }
                }
                stmt.setNull(i + 1, sqlType);
            }
        }
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuilder msg = new StringBuilder(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    protected void close(Connection conn) throws SQLException {
        CloseUtil.close((Connection)conn);
    }

    protected void close(Statement stmt) throws SQLException {
        CloseUtil.close((Statement)stmt);
    }

    protected void close(ResultSet rs) throws SQLException {
        CloseUtil.close((ResultSet)rs);
    }
}

