/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.util;

import com.kingdee.bos.qing.data.model.designtime.ParameterDataType;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.util.HashMap;
import java.util.Map;

public class ParameterDataTypeUtil {
    private static Map<ParameterDataType, Integer> INPUTDBDATATYPES_MAP = new HashMap<ParameterDataType, Integer>();
    private static Map<ParameterDataType, Integer> OUTPUTBDATATYPES_MAP = new HashMap<ParameterDataType, Integer>();
    private static Map<ParameterDataType, DataType> DATATYPES_MAP = new HashMap<ParameterDataType, DataType>();
    private static Map<String, ParameterDataType> DBDATATYPE_MAP = new HashMap<String, ParameterDataType>();

    public static Integer getOutputDBDataType(DBSource.DBType dbType, ParameterDataType dataType) {
        if (dataType == ParameterDataType.CURSOR && dbType == DBSource.DBType.ORACLE) {
            return -10;
        }
        return OUTPUTBDATATYPES_MAP.get((Object)dataType);
    }

    public static Integer getInputDBDataType(ParameterDataType dataType) {
        return INPUTDBDATATYPES_MAP.get((Object)dataType);
    }

    public static DataType getDataType(ParameterDataType dataType) {
        return DATATYPES_MAP.get((Object)dataType);
    }

    public static final ParameterDataType dbDataTypeToParameterDataType(String value) {
        if (value == null) {
            return ParameterDataType.STRING;
        }
        ParameterDataType parameterDataType = DBDATATYPE_MAP.get(value.toLowerCase());
        if (parameterDataType == null) {
            parameterDataType = ParameterDataType.STRING;
        }
        return parameterDataType;
    }

    static {
        DBDATATYPE_MAP.put("bit", ParameterDataType.BOOLEAN);
        DBDATATYPE_MAP.put("char", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("nchar", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("ntext", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("nvarchar", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("text", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("varchar", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("varchar2", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("nvarchar2", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("character", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("character varying", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("clob", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("blob", ParameterDataType.STRING);
        DBDATATYPE_MAP.put("int", ParameterDataType.INT);
        DBDATATYPE_MAP.put("smallint", ParameterDataType.INT);
        DBDATATYPE_MAP.put("tinyint", ParameterDataType.INT);
        DBDATATYPE_MAP.put("long", ParameterDataType.INT);
        DBDATATYPE_MAP.put("integer", ParameterDataType.INT);
        DBDATATYPE_MAP.put("bigint", ParameterDataType.INT);
        DBDATATYPE_MAP.put("binary_integer", ParameterDataType.INT);
        DBDATATYPE_MAP.put("decimal", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("float", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("numeric", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("real", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("number", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("double precision", ParameterDataType.NUMBER);
        DBDATATYPE_MAP.put("datetime", ParameterDataType.DATE);
        DBDATATYPE_MAP.put("smalldatetime", ParameterDataType.DATE);
        DBDATATYPE_MAP.put("date", ParameterDataType.DATE);
        DBDATATYPE_MAP.put("timestamp", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("time", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("timestamp with time zone", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("timestamp without time zone", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("times with time zone", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("times without time zone", ParameterDataType.DATETIME);
        DBDATATYPE_MAP.put("ref cursor", ParameterDataType.CURSOR);
        DBDATATYPE_MAP.put("refcursor", ParameterDataType.CURSOR);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.BOOLEAN, 16);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.INT, 4);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.NUMBER, 4);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.DATE, 91);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.DATETIME, 93);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.STRING, 12);
        INPUTDBDATATYPES_MAP.put(ParameterDataType.CURSOR, 1111);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.BOOLEAN, 16);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.INT, 4);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.NUMBER, 4);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.DATE, 91);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.DATETIME, 93);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.STRING, 12);
        OUTPUTBDATATYPES_MAP.put(ParameterDataType.CURSOR, 1111);
        DATATYPES_MAP.put(ParameterDataType.BOOLEAN, DataType.BOOLEAN);
        DATATYPES_MAP.put(ParameterDataType.INT, DataType.INT);
        DATATYPES_MAP.put(ParameterDataType.NUMBER, DataType.NUMBER);
        DATATYPES_MAP.put(ParameterDataType.DATE, DataType.DATE);
        DATATYPES_MAP.put(ParameterDataType.DATETIME, DataType.DATETIME);
        DATATYPES_MAP.put(ParameterDataType.STRING, DataType.STRING);
    }
}

