/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.util.LogUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Element;

public class FileSource
extends AbstractSource
implements IFileSavable {
    private String name;
    private FileType fileType;
    private String fileUrl;
    private String fileName;
    private String characterSet;
    private int defineTypeRowCount;
    private transient String hashcode;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals(this.name)) {
            this.hashcode = DigestUtils.md5Hex((String)this.getName());
        }
        this.name = name;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    @Override
    public SourceType getType() {
        return SourceType.File;
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("FileSource");
        node.setAttribute("name", this.name);
        node.setAttribute("fileType", this.fileType.toPersistance());
        node.setAttribute("fileUrl", this.fileUrl);
        node.setAttribute("fileName", this.fileName);
        node.setAttribute("characterSet", this.characterSet);
        node.setAttribute("defineTypeRowCount", this.defineTypeRowCount + "");
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        this.name = node.getAttributeValue("name");
        this.fileType = FileType.fromPersistance(node.getAttributeValue("fileType"));
        this.fileUrl = node.getAttributeValue("fileUrl");
        this.fileName = node.getAttributeValue("fileName");
        this.characterSet = null != node.getAttributeValue("characterSet") ? node.getAttributeValue("characterSet") : "GB18030";
        this.defineTypeRowCount = null != node.getAttributeValue("defineTypeRowCount") ? Integer.parseInt(node.getAttributeValue("defineTypeRowCount")) : 50;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileUrl() {
        return this.fileUrl;
    }

    @Override
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public int getDefineTypeRowCount() {
        return this.defineTypeRowCount;
    }

    public void setDefineTypeRowCount(int defineTypeRowCount) {
        this.defineTypeRowCount = defineTypeRowCount;
    }

    @Override
    public String getSourceHashCode() {
        if (this.hashcode == null) {
            this.hashcode = DigestUtils.md5Hex((String)this.getName());
        }
        return this.hashcode;
    }

    @Override
    public AbstractSource cloneUserRecentUsedSource() {
        FileSource fileSource = null;
        try {
            fileSource = (FileSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LogUtil.error((String)"fileSource cloneUserRecentUsedSource error", (Throwable)e);
        }
        return fileSource;
    }

    public static enum FileType {
        EXCEL,
        CSV,
        TXT,
        XML;


        public String toPersistance() {
            return this.name();
        }

        public static FileType fromPersistance(String name) throws ModelParseException {
            try {
                return FileType.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown FileType: " + name);
            }
        }
    }
}

