/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source.authmodel;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.BasicAuthModel;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.BearerAuthModel;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.CosmicAuthModel;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.DigestAuthModel;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public abstract class AbstractAuthModel {
    private OpenAPIAuthType authType;
    private static EnumMap<OpenAPIAuthType, Class<? extends AbstractAuthModel>> map = new EnumMap(OpenAPIAuthType.class);

    public void setAuthType(OpenAPIAuthType authType) {
        this.authType = authType;
    }

    public OpenAPIAuthType getAuthType() {
        return this.authType;
    }

    public final Element toXml() {
        Element node = this.innerToXml();
        node.setAttribute("authType", this.getType().toPersistance());
        return node;
    }

    protected abstract OpenAPIAuthType getType();

    public abstract Map<String, String> createRequestHeads(String var1) throws OpenAPIAuthException;

    protected abstract Element innerToXml();

    public abstract void fromXml(Element var1) throws ModelParseException;

    public abstract AbstractAuthModel instanceFromJson(JsonUtil.AbstractJsonDecoder.Json var1, AuthModelJsonDecoder var2);

    public abstract boolean isErrorParam();

    public abstract String getAuthModelHashCode();

    public static AbstractAuthModel instanceFromXml(Element authElement) throws ModelParseException {
        String authType = authElement.getAttributeValue("authType");
        OpenAPIAuthType type = OpenAPIAuthType.fromPersistance(authType);
        try {
            AbstractAuthModel authModel = map.get((Object)type).newInstance();
            return authModel;
        }
        catch (Exception e) {
            throw new ModelParseException("Unknown OpenAPIAuthType:" + authType, e);
        }
    }

    static {
        map.put(OpenAPIAuthType.BASIC, BasicAuthModel.class);
        map.put(OpenAPIAuthType.BEARER, BearerAuthModel.class);
        map.put(OpenAPIAuthType.DIGEST, DigestAuthModel.class);
        map.put(OpenAPIAuthType.COSMIC, CosmicAuthModel.class);
    }

    public static class AuthModelJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractAuthModel> {
        protected final AbstractAuthModel decode(JsonUtil.AbstractJsonDecoder.Json json) {
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                try {
                    AbstractAuthModel abstractAuthModel = (AbstractAuthModel)((Class)entry.getValue()).newInstance();
                    AbstractAuthModel authModel = abstractAuthModel.instanceFromJson(json, this);
                    if (authModel == null) continue;
                    return authModel;
                }
                catch (Exception e) {
                    LogUtil.error((String)("Unknown OpenAPIAuthType:" + entry.getKey()), (Throwable)e);
                }
            }
            return null;
        }

        public <U extends AbstractAuthModel> AbstractAuthModel fromJson2(JsonUtil.AbstractJsonDecoder.Json json, Class<U> clz) {
            return (AbstractAuthModel)this.fromJson(json, clz);
        }
    }

    public static enum OpenAPIAuthType {
        BASIC,
        BEARER,
        DIGEST,
        COSMIC;


        public String toPersistance() {
            return this.name();
        }

        public static OpenAPIAuthType fromPersistance(String name) throws ModelParseException {
            try {
                return OpenAPIAuthType.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown OpenAPIAuthType: " + name);
            }
        }
    }
}

