/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source.authmodel;

import com.google.gson.JsonObject;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.domain.source.db.util.AESUtil;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Element;

public class BearerAuthModel
extends AbstractAuthModel {
    private static final String GRANT_TYPE = "client_credentials";
    private String clientId;
    private String clientSecret;
    private String scope;
    private String authURL;

    @Override
    protected AbstractAuthModel.OpenAPIAuthType getType() {
        return AbstractAuthModel.OpenAPIAuthType.BEARER;
    }

    @Override
    public Map<String, String> createRequestHeads(String url) throws OpenAPIAuthException {
        try {
            String cacheKey;
            String accessToken;
            HashMap<String, String> headsMap = new HashMap<String, String>(1);
            IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
            StringBuilder sb = new StringBuilder("BEARER_");
            sb.append(this.clientId).append("_").append(this.clientSecret).append("_").append(this.authURL);
            if (this.scope != null) {
                sb.append("_").append(this.scope);
            }
            if ((accessToken = globalQingSession.get(cacheKey = sb.toString())) == null) {
                HashMap<String, String> requestBody = new HashMap<String, String>(4);
                requestBody.put("client_id", this.clientId);
                requestBody.put("client_secret", new String(Base64.decodeBase64((String)this.clientSecret), "UTF-8"));
                if (this.scope != null) {
                    requestBody.put("scope", this.scope);
                }
                requestBody.put("grant_type", GRANT_TYPE);
                String response = HttpUtil.post((String)this.authURL, null, (String)JsonUtil.encodeToString(requestBody));
                JsonObject jsonObject = (JsonObject)JsonUtil.decodeFromString((String)response, JsonObject.class);
                JsonObject resultObject = jsonObject.getAsJsonObject("result");
                accessToken = resultObject.get("token").getAsString();
                globalQingSession.set(cacheKey, accessToken, 1, TimeUnit.HOURS);
            }
            headsMap.put("Authorization", accessToken);
            return headsMap;
        }
        catch (Exception e) {
            throw new OpenAPIAuthException(e.getMessage());
        }
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("AuthModel");
        node.setAttribute("clientId", this.clientId);
        node.setAttribute("clientSecret", AESUtil.aesByString(this.clientSecret, 1));
        if (this.scope != null) {
            node.setAttribute("scope", this.scope);
        }
        node.setAttribute("authURL", this.authURL);
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        this.clientId = node.getAttributeValue("clientId");
        this.clientSecret = AESUtil.aesByString(node.getAttributeValue("clientSecret"), 2);
        this.scope = node.getAttributeValue("scope");
        this.authURL = node.getAttributeValue("authURL");
        this.setAuthType(AbstractAuthModel.OpenAPIAuthType.BEARER);
    }

    @Override
    public AbstractAuthModel instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, AbstractAuthModel.AuthModelJsonDecoder jsonDecoder) {
        if (AbstractAuthModel.OpenAPIAuthType.BEARER.toPersistance().equals(json.getAttrValue("authType"))) {
            return jsonDecoder.fromJson2(json, BearerAuthModel.class);
        }
        return null;
    }

    @Override
    public boolean isErrorParam() {
        return StringUtils.isBlank((CharSequence)this.clientId) || StringUtils.isBlank((CharSequence)this.clientSecret) || StringUtils.isBlank((CharSequence)this.authURL);
    }

    @Override
    public String getAuthModelHashCode() {
        return DigestUtils.md5Hex((String)(this.clientId + this.clientSecret + this.authURL));
    }
}

