/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source.authmodel;

import com.kingdee.bos.qing.data.domain.source.db.util.AESUtil;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.data.util.TokenUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Element;

public class CosmicAuthModel
extends AbstractAuthModel {
    private String appId;
    private String appSecret;
    private UserType userType;
    private String userTypeValue;
    private CosmicType cosmicType;
    private String accountId;
    private String tenantId;
    private String cosmicServerAddress;

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getUserTypeValue() {
        return this.userTypeValue;
    }

    public CosmicType getCosmicType() {
        return this.cosmicType;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getCosmicServerAddress() {
        return this.cosmicServerAddress;
    }

    @Override
    protected AbstractAuthModel.OpenAPIAuthType getType() {
        return AbstractAuthModel.OpenAPIAuthType.COSMIC;
    }

    @Override
    public Map<String, String> createRequestHeads(String url) throws OpenAPIAuthException {
        HashMap<String, String> headsMap = new HashMap<String, String>(2);
        try {
            String accessToken = TokenUtil.getAccessToken(this, headsMap);
            headsMap.put("accessToken", accessToken);
        }
        catch (OpenAPIAuthException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenAPIAuthException(e.getMessage());
        }
        return headsMap;
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("AuthModel");
        node.setAttribute("appId", this.appId);
        node.setAttribute("appSecret", AESUtil.aesByString(this.appSecret, 1));
        node.setAttribute("userType", this.userType.toPersistance());
        node.setAttribute("userTypeValue", this.userTypeValue);
        if (this.cosmicType != null) {
            node.setAttribute("cosmicType", this.cosmicType.toPersistance());
        }
        if (this.cosmicType == null || CosmicType.Other == this.cosmicType) {
            node.setAttribute("accountId", this.accountId);
            node.setAttribute("tenantId", this.tenantId);
            node.setAttribute("cosmicServerAddress", this.cosmicServerAddress);
        }
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        this.setAuthType(AbstractAuthModel.OpenAPIAuthType.COSMIC);
        this.appId = node.getAttributeValue("appId");
        this.appSecret = AESUtil.aesByString(node.getAttributeValue("appSecret"), 2);
        this.userType = UserType.fromPersistance(node.getAttributeValue("userType"));
        this.userTypeValue = node.getAttributeValue("userTypeValue");
        if (node.getAttributeValue("cosmicType") != null) {
            this.cosmicType = CosmicType.fromPersistance(node.getAttributeValue("cosmicType"));
        }
        this.accountId = node.getAttributeValue("accountId");
        this.tenantId = node.getAttributeValue("tenantId");
        this.cosmicServerAddress = node.getAttributeValue("cosmicServerAddress");
    }

    @Override
    public AbstractAuthModel instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, AbstractAuthModel.AuthModelJsonDecoder jsonDecoder) {
        if (AbstractAuthModel.OpenAPIAuthType.COSMIC.toPersistance().equals(json.getAttrValue("authType"))) {
            return jsonDecoder.fromJson2(json, CosmicAuthModel.class);
        }
        return null;
    }

    @Override
    public boolean isErrorParam() {
        if (StringUtils.isBlank((CharSequence)this.appId) || StringUtils.isBlank((CharSequence)this.appSecret)) {
            return true;
        }
        if ((this.cosmicType == null || CosmicType.Other == this.cosmicType) && (StringUtils.isBlank((CharSequence)this.cosmicServerAddress) || StringUtils.isBlank((CharSequence)this.accountId))) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)this.userType.toPersistance()) || StringUtils.isBlank((CharSequence)this.userTypeValue);
    }

    @Override
    public String getAuthModelHashCode() {
        return DigestUtils.md5Hex((String)(this.appId + this.appSecret + this.userTypeValue));
    }

    public static enum CosmicType {
        Local,
        Other;


        public String toPersistance() {
            return this.name();
        }

        public static CosmicType fromPersistance(String name) throws ModelParseException {
            try {
                return CosmicType.valueOf(name);
            }
            catch (Exception e) {
                throw new ModelParseException("Unknown CosmicType: " + name);
            }
        }
    }

    public static enum UserType {
        Mobile,
        Email,
        UserName;


        public String toPersistance() {
            return this.name();
        }

        public static UserType fromPersistance(String name) throws ModelParseException {
            try {
                return UserType.valueOf(name);
            }
            catch (Exception e) {
                throw new ModelParseException("Unknown UserType: " + name);
            }
        }
    }
}

